/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.world.miscellaneous;

import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Server;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractIC;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.mechanics.ic.ICVerificationException;
import org.enginehub.craftbook.mechanics.ic.RestrictedIC;
import org.enginehub.craftbook.util.RegexUtil;

public class SoundEffect
extends AbstractIC {
    float volume;
    byte pitch;
    Sound sound;

    public SoundEffect(Server server, BukkitChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public void load() {
        String[] split = RegexUtil.COLON_PATTERN.split(this.getLine(2));
        try {
            this.volume = Float.parseFloat(split[0]) / 100.0f;
        }
        catch (Exception e) {
            this.volume = 100.0f;
        }
        try {
            this.pitch = Byte.parseByte(split[1]);
        }
        catch (Exception e) {
            this.pitch = 0;
        }
        String soundName = this.getLine(3).trim();
        try {
            this.sound = Sound.valueOf((String)soundName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.sound == null && this.getLine(3).trim().length() == 15) {
            for (Sound s : Sound.values()) {
                if (s.name().length() <= 15 || !s.name().startsWith(this.getLine(3))) continue;
                this.sound = s;
                break;
            }
        }
        if (this.sound == null) {
            this.sound = Sound.ENTITY_COW_AMBIENT;
        }
    }

    @Override
    public String getTitle() {
        return "Sound Effect";
    }

    @Override
    public String getSignTitle() {
        return "SOUND EFFECT";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            this.doSound();
        }
    }

    public void doSound() {
        Block b = this.getBackBlock();
        b.getWorld().playSound(b.getLocation(), this.sound, this.volume, (float)this.pitch);
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new SoundEffect(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Plays a sound effect on high.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"volume:pitch", "sound name"};
        }

        @Override
        public void verify(BukkitChangedSign sign) throws ICVerificationException {
            String line3 = PlainTextComponentSerializer.plainText().serialize(sign.getLine(3));
            Sound sound = null;
            try {
                sound = Sound.valueOf((String)line3.trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (sound == null && line3.trim().length() == 15) {
                for (Sound s : Sound.values()) {
                    if (s.name().length() <= 15 || !s.name().startsWith(line3)) continue;
                    sound = s;
                    break;
                }
            }
            if (sound == null) {
                throw new ICVerificationException("Unknown Sound!");
            }
        }
    }
}

