/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.world.miscellaneous;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.Server;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.util.jinglenote.Playlist;

public class RadioStation
extends AbstractSelfTriggeredIC {
    String band;
    public static final Map<String, Playlist> stations = new HashMap<String, Playlist>();

    public RadioStation(Server server, BukkitChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    public static Playlist getPlaylist(String band) {
        return stations.get(band);
    }

    @Override
    public boolean isAlwaysST() {
        return true;
    }

    @Override
    public void load() {
        this.band = this.getLine(3);
        Playlist playlist = new Playlist(this.getLine(2));
        stations.put(this.band, playlist);
    }

    @Override
    public String getTitle() {
        return "Radio Station";
    }

    @Override
    public String getSignTitle() {
        return "RADIO STATION";
    }

    @Override
    public void trigger(ChipState chip) {
        Playlist playlist = null;
        if (!stations.containsKey(this.band)) {
            playlist = new Playlist(this.getLine(2));
            stations.put(this.band, playlist);
        } else {
            playlist = stations.get(this.band);
        }
        if (chip.getInput(0) && !playlist.isPlaying()) {
            playlist.startPlaylist();
        } else if (!chip.getInput(0) && playlist.isPlaying()) {
            playlist.stopPlaylist();
        }
        chip.setOutput(0, playlist.isPlaying());
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new RadioStation(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Broadcasts a playlist.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"Playlist Name", "Radio Band"};
        }
    }
}

