/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.world.miscellaneous;

import com.sk89q.worldedit.math.BlockVector3;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractIC;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.mechanics.ic.RestrictedIC;
import org.enginehub.craftbook.util.ICUtil;

public class LightningSummon
extends AbstractIC {
    private Location center;
    private BlockVector3 radius;
    private int chance;

    public LightningSummon(Server server, BukkitChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public void load() {
        if (!this.getLine(2).isEmpty()) {
            this.radius = ICUtil.parseRadius(this.getSign()).toBlockPoint();
            this.center = this.getLine(2).contains("=") ? ICUtil.parseBlockLocation(this.getSign()).getLocation() : this.getBackBlock().getLocation();
        } else {
            this.center = this.getBackBlock().getLocation();
            this.radius = BlockVector3.at((int)1, (int)1, (int)1);
        }
        if (!this.getLine(3).isEmpty()) {
            try {
                this.chance = Math.min(Integer.parseInt(this.getLine(3)), 100);
            }
            catch (Exception e) {
                this.chance = 100;
            }
        } else {
            this.chance = 100;
        }
    }

    @Override
    public String getTitle() {
        return "Zeus Bolt";
    }

    @Override
    public String getSignTitle() {
        return "ZEUS BOLT";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            for (int x = -this.radius.x() + 1; x < this.radius.x(); ++x) {
                for (int y = -this.radius.y() + 1; y < this.radius.y(); ++y) {
                    for (int z = -this.radius.z() + 1; z < this.radius.z(); ++z) {
                        int rx = this.center.getBlockX() - x;
                        int ry = this.center.getBlockY() - y;
                        int rz = this.center.getBlockZ() - z;
                        Block b = this.getSign().getBlock().getWorld().getBlockAt(rx, ry, rz);
                        if (b.getType() == Material.AIR || ThreadLocalRandom.current().nextInt(100) > this.chance) continue;
                        b.getWorld().strikeLightning(b.getLocation());
                    }
                }
            }
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new LightningSummon(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Strike location with lightning!";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"+oradius=x:y:z block offset", "+ochance"};
        }
    }
}

