/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.world.miscellaneous;

import com.sk89q.util.yaml.YAMLProcessor;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.plugin.Plugin;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.mechanics.ic.AbstractIC;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.ConfigurableIC;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.mechanics.ic.ICVerificationException;
import org.enginehub.craftbook.mechanics.ic.RestrictedIC;
import org.enginehub.craftbook.util.SignUtil;

public class FlameThrower
extends AbstractIC {
    private int distance;
    private int delay;

    public FlameThrower(Server server, BukkitChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public void load() {
        try {
            this.distance = Math.min(((Factory)this.getFactory()).maxRange, Integer.parseInt(this.getLine(2)));
        }
        catch (Exception ignored) {
            this.distance = 10;
        }
        try {
            this.delay = Integer.parseInt(this.getLine(3));
        }
        catch (Exception ignored) {
            this.delay = 0;
        }
    }

    @Override
    public String getTitle() {
        return "Flame Thrower";
    }

    @Override
    public String getSignTitle() {
        return "FLAME THROWER";
    }

    @Override
    public void trigger(ChipState chip) {
        this.sendFlames(chip.getInput(0));
    }

    public void sendFlames(boolean make) {
        Block block = this.getSign().getBlock();
        BlockFace direction = SignUtil.getBack(block);
        if (this.delay <= 0) {
            Block fire = block.getRelative(direction, 2);
            for (int i = 0; i < this.distance; ++i) {
                if (make) {
                    if (fire.getType() == Material.AIR || fire.getType() == Material.SHORT_GRASS) {
                        fire.setType(Material.FIRE);
                    }
                } else if (fire.getType() == Material.FIRE) {
                    fire.setType(Material.AIR);
                }
                fire = fire.getRelative(direction);
            }
        } else {
            int i = 0;
            while (i < this.distance) {
                int fi = i++;
                CraftBookPlugin.inst().getServer().getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), () -> {
                    Block fire = block.getRelative(direction, 2 + fi);
                    if (make) {
                        if (fire.getType() == Material.AIR || fire.getType() == Material.SHORT_GRASS) {
                            fire.setType(Material.FIRE);
                        }
                    } else if (fire.getType() == Material.FIRE) {
                        fire.setType(Material.AIR);
                    }
                }, (long)(this.delay * fi));
            }
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC,
    ConfigurableIC {
        public int maxRange;

        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new FlameThrower(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Makes a line of fire.";
        }

        @Override
        public String[] getLongDescription() {
            return new String[]{"The '''MC1252''' sets a certain length of blocks in fron of the IC block on fire (putting fire Block on top of them)."};
        }

        @Override
        public void verify(BukkitChangedSign sign) throws ICVerificationException {
            try {
                int distance = Integer.parseInt(PlainTextComponentSerializer.plainText().serialize(sign.getLine(2)));
                if (distance > this.maxRange) {
                    throw new ICVerificationException("Distance too great!");
                }
            }
            catch (Exception ignored) {
                throw new ICVerificationException("Invalid distance!");
            }
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"distance", "delay"};
        }

        @Override
        public void addConfiguration(YAMLProcessor config, String path) {
            config.setComment("max-fire-range", "The maximum range the Flamethrower IC can be set to.");
            this.maxRange = config.getInt("max-fire-range", 20);
        }
    }
}

