/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.world.miscellaneous;

import java.util.concurrent.ThreadLocalRandom;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.SmallFireball;
import org.bukkit.util.Vector;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractIC;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.mechanics.ic.RestrictedIC;
import org.enginehub.craftbook.util.RegexUtil;
import org.enginehub.craftbook.util.SignUtil;

public class FireShooter
extends AbstractIC {
    private double speed;
    private double spread;
    private double vert;

    public FireShooter(Server server, BukkitChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public void load() {
        try {
            String[] velocity = RegexUtil.COLON_PATTERN.split(this.getLine(2).trim());
            this.speed = Double.parseDouble(velocity[0]);
            this.spread = Double.parseDouble(velocity[1]);
            this.vert = Double.parseDouble(this.getLine(3).trim());
        }
        catch (Exception e) {
            this.speed = 1.6f;
            this.spread = 12.0;
            this.vert = 0.2f;
            this.getSign().setLine(2, (Component)Component.text((String)(this.speed + ":" + this.spread)));
            this.getSign().setLine(3, (Component)Component.text((double)this.vert));
            this.getSign().update(false);
        }
        if (this.speed > 10.0) {
            this.speed = 10.0;
        } else if (this.speed < 0.1) {
            this.speed = 0.1f;
        }
        if (this.spread > 5000.0) {
            this.spread = 5000.0;
        } else if (this.spread < 0.0) {
            this.spread = 0.0;
        }
        if (this.vert > 100.0) {
            this.vert = 100.0;
        } else if (this.vert < -100.0) {
            this.vert = -100.0;
        }
    }

    @Override
    public String getTitle() {
        return "Fire Shooter";
    }

    @Override
    public String getSignTitle() {
        return "FIRE SHOOTER";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            this.shootFire(1);
        }
    }

    public void shootFire(int n) {
        Block signBlock = this.getSign().getBlock();
        BlockFace face = SignUtil.getBack(signBlock);
        Block targetDir = signBlock.getRelative(face).getRelative(face);
        double x = targetDir.getX() - signBlock.getX();
        double z = targetDir.getZ() - signBlock.getZ();
        Location shootLoc = new Location(this.getSign().getBlock().getWorld(), (double)targetDir.getX() + 0.5, (double)targetDir.getY() + 0.5, (double)targetDir.getZ() + 0.5);
        if (!shootLoc.getChunk().isLoaded()) {
            return;
        }
        for (int i = 0; i < n; i = (int)((short)(i + 1))) {
            double f2 = Math.sqrt(x * x + this.vert * this.vert + z * z);
            double nx = x / f2;
            double ny = this.vert / f2;
            double nz = z / f2;
            nx += ThreadLocalRandom.current().nextGaussian() * (double)0.0075f * this.spread;
            ny += ThreadLocalRandom.current().nextGaussian() * (double)0.0075f * this.spread;
            nz += ThreadLocalRandom.current().nextGaussian() * (double)0.0075f * this.spread;
            float f3 = (float)Math.sqrt((nx *= this.speed) * nx + (nz *= this.speed) * nz);
            SmallFireball f = (SmallFireball)this.getSign().getBlock().getWorld().spawn(shootLoc, SmallFireball.class);
            f.setVelocity(new Vector(nx, ny *= this.speed, nz));
            f.getLocation().setYaw((float)(Math.atan2(nx, nz) * 180.0 / 3.1415927410125732));
            f.getLocation().setPitch((float)(Math.atan2(ny, f3) * 180.0 / 3.1415927410125732));
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new FireShooter(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Shoots a fireball.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"speed:spread", "vertical gain"};
        }
    }
}

