/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.world.miscellaneous;

import org.bukkit.Server;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.mechanics.ic.RestrictedIC;
import org.enginehub.craftbook.mechanics.ic.gates.world.miscellaneous.FireShooter;

public class FireBarrage
extends FireShooter {
    public FireBarrage(Server server, BukkitChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public String getTitle() {
        return "Fire Barrage";
    }

    @Override
    public String getSignTitle() {
        return "FIRE BARRAGE";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            this.shootFire(5);
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new FireBarrage(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Shoots a barrage of fire.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"speed:spread", "vertical gain"};
        }
    }
}

