/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.world.miscellaneous;

import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.util.Vector;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractIC;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.mechanics.ic.RestrictedIC;
import org.enginehub.craftbook.util.RegexUtil;
import org.enginehub.craftbook.util.SignUtil;

public class ArrowShooter
extends AbstractIC {
    double speed;
    double spread;
    double vert;

    public ArrowShooter(Server server, BukkitChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public void load() {
        try {
            String[] velocity = RegexUtil.COLON_PATTERN.split(this.getLine(2).trim());
            this.speed = Double.parseDouble(velocity[0]);
            this.spread = Double.parseDouble(velocity[1]);
            this.vert = Double.parseDouble(this.getLine(3).trim());
        }
        catch (Exception e) {
            this.speed = 1.6f;
            this.spread = 12.0;
            this.vert = 0.2f;
            this.getSign().setLine(2, (Component)Component.text((String)(this.speed + ":" + this.spread)));
            this.getSign().setLine(3, (Component)Component.text((double)this.vert));
            this.getSign().update(false);
        }
        if (this.speed > 10.0) {
            this.speed = 10.0;
        } else if (this.speed < 0.1) {
            this.speed = 0.1f;
        }
        if (this.spread > 5000.0) {
            this.spread = 5000.0;
        } else if (this.spread < 0.0) {
            this.spread = 0.0;
        }
        if (this.vert > 100.0) {
            this.vert = 100.0;
        } else if (this.vert < -100.0) {
            this.vert = -100.0;
        }
    }

    @Override
    public String getTitle() {
        return "Arrow Shooter";
    }

    @Override
    public String getSignTitle() {
        return "ARROW SHOOTER";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            this.shootArrows(1);
        }
    }

    public void shootArrows(int n) {
        Block signBlock = this.getSign().getBlock();
        BlockFace face = SignUtil.getBack(signBlock);
        Block targetDir = signBlock.getRelative(face).getRelative(face);
        double x = targetDir.getX() - signBlock.getX();
        double z = targetDir.getZ() - signBlock.getZ();
        Vector velocity = new Vector(x, this.vert, z);
        Location shootLoc = new Location(this.getSign().getBlock().getWorld(), (double)targetDir.getX() + 0.5, (double)targetDir.getY() + 0.5, (double)targetDir.getZ() + 0.5);
        if (!shootLoc.getChunk().isLoaded()) {
            return;
        }
        for (int i = 0; i < n; i = (int)((short)(i + 1))) {
            this.getSign().getBlock().getWorld().spawnArrow(shootLoc, velocity, (float)this.speed, (float)this.spread);
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new ArrowShooter(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Shoots an arrow.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"speed:spread", "vertical gain"};
        }
    }
}

