/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.world.items;

import java.util.ArrayList;
import java.util.Collections;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.mechanics.ic.PipeInputIC;
import org.enginehub.craftbook.mechanics.pipe.PipePutEvent;
import org.enginehub.craftbook.mechanics.pipe.PipeRequestEvent;
import org.enginehub.craftbook.util.InventoryUtil;
import org.enginehub.craftbook.util.ItemUtil;
import org.enginehub.craftbook.util.RegexUtil;
import org.enginehub.craftbook.util.SignUtil;

public class Sorter
extends AbstractSelfTriggeredIC
implements PipeInputIC {
    Block chestBlock;
    boolean inverted;
    boolean ignoreDurability;
    boolean ignoreEnchants;
    boolean ignoreMeta;

    public Sorter(Server server, BukkitChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public void load() {
        this.chestBlock = this.getBackBlock().getRelative(0, 1, 0);
        this.inverted = this.getLine(2).equalsIgnoreCase("invert");
        for (String line4 : RegexUtil.PIPE_PATTERN.split(this.getLine(3))) {
            if (line4.equalsIgnoreCase("!D")) {
                this.ignoreDurability = true;
            }
            if (line4.equalsIgnoreCase("!E")) {
                this.ignoreEnchants = true;
            }
            if (!line4.equalsIgnoreCase("!M")) continue;
            this.ignoreMeta = true;
        }
    }

    @Override
    public String getTitle() {
        return "Sorter";
    }

    @Override
    public String getSignTitle() {
        return "SORTER";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.sort());
        }
    }

    @Override
    public void think(ChipState state) {
        state.setOutput(0, this.sort());
    }

    public boolean sort() {
        boolean returnValue = false;
        for (Item item : ItemUtil.getItemsAtBlock(this.getSign().getBlock())) {
            if (!this.sortItemStack(item.getItemStack())) continue;
            item.remove();
            returnValue = true;
        }
        return returnValue;
    }

    public boolean sortItemStack(ItemStack item) {
        BlockFace back = SignUtil.getBack(this.getSign().getBlock());
        Block b = this.isInAboveContainer(item) ^ this.inverted ? SignUtil.getRightBlock(this.getSign().getBlock()).getRelative(back) : SignUtil.getLeftBlock(this.getSign().getBlock()).getRelative(back);
        PipeRequestEvent event = new PipeRequestEvent(b, new ArrayList<ItemStack>(Collections.singletonList(item)), this.getBackBlock());
        Bukkit.getPluginManager().callEvent((Event)event);
        for (ItemStack it : event.getItems()) {
            b.getWorld().dropItemNaturally(b.getLocation().add(0.5, 0.5, 0.5), it);
        }
        return true;
    }

    public boolean isInAboveContainer(ItemStack item) {
        ItemStack itemClone = item.clone();
        itemClone.setAmount(1);
        return InventoryUtil.doesBlockHaveInventory(this.chestBlock) && InventoryUtil.doesInventoryContain(((InventoryHolder)this.chestBlock.getState()).getInventory(), true, this.ignoreDurability, this.ignoreMeta, this.ignoreEnchants, itemClone);
    }

    @Override
    public void onPipeTransfer(PipePutEvent event) {
        ArrayList<ItemStack> leftovers = new ArrayList<ItemStack>();
        for (ItemStack item : event.getItems()) {
            if (!ItemUtil.isStackValid(item) || this.sortItemStack(item)) continue;
            leftovers.add(item);
        }
        event.setItems(leftovers);
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new Sorter(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Sorts items and spits out left/right depending on above chest.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"invert - to invert output sides", null};
        }
    }
}

