/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.world.items;

import com.google.common.collect.Lists;
import com.sk89q.worldedit.math.Vector3;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.bukkit.events.RangedCollectEvent;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.util.ICUtil;
import org.enginehub.craftbook.util.InventoryUtil;
import org.enginehub.craftbook.util.ItemSyntax;
import org.enginehub.craftbook.util.ItemUtil;
import org.enginehub.craftbook.util.RegexUtil;
import org.enginehub.craftbook.util.SignUtil;

public class RangedCollector
extends AbstractSelfTriggeredIC {
    private Vector3 radius;
    private Location centre;
    private boolean include = false;
    private Block chest;
    private List<ItemStack> filters = new ArrayList<ItemStack>();

    public RangedCollector(Server server, BukkitChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public String getTitle() {
        return "Ranged Collector";
    }

    @Override
    public String getSignTitle() {
        return "RANGED COLLECTOR";
    }

    @Override
    public void think(ChipState chip) {
        if (chip.getInput(0)) {
            return;
        }
        chip.setOutput(0, this.collect());
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.collect());
        }
    }

    @Override
    public void load() {
        this.radius = ICUtil.parseRadius(this.getSign());
        Object radiusString = this.radius.x() + "," + this.radius.y() + "," + this.radius.z();
        if (this.radius.x() == this.radius.y() && this.radius.y() == this.radius.z()) {
            radiusString = String.valueOf(this.radius.x());
        }
        if (this.getLine(2).contains("=")) {
            this.getSign().setLine(2, (Component)Component.text((String)((String)radiusString + "=" + RegexUtil.EQUALS_PATTERN.split(this.getLine(2))[1])));
            this.centre = ICUtil.parseBlockLocation(this.getSign(), 2).getLocation();
        } else {
            this.getSign().setLine(2, (Component)Component.text((String)radiusString));
            this.centre = this.getBackBlock().getLocation();
        }
        this.include = !this.getLine(3).startsWith("-");
        for (String bit : this.getLine(3).replace("-", "").split(",")) {
            ItemStack item;
            if (bit.trim().length() <= 0 || !ItemUtil.isStackValid(item = ItemSyntax.getItem(bit))) continue;
            this.filters.add(ItemSyntax.getItem(bit));
        }
        this.chest = this.getBackBlock().getRelative(0, 1, 0);
    }

    public boolean collect() {
        boolean collected = false;
        ArrayList itemsForChest = Lists.newArrayList();
        for (Entity entity : this.centre.getNearbyEntities(this.radius.x(), this.radius.y(), this.radius.z())) {
            if (!entity.isValid() || !(entity instanceof Item) || ((Item)entity).getPickupDelay() >= 1) continue;
            ItemStack stack = ((Item)entity).getItemStack();
            if (!ItemUtil.isStackValid(stack)) {
                return false;
            }
            boolean passed = this.filters.isEmpty() || !this.include;
            for (ItemStack filter : this.filters) {
                if (!ItemUtil.isStackValid(filter)) continue;
                if (this.include && ItemUtil.areItemsIdentical(filter, stack)) {
                    passed = true;
                    break;
                }
                if (this.include || !ItemUtil.areItemsIdentical(filter, stack)) continue;
                passed = false;
                break;
            }
            if (!passed) continue;
            BlockFace back = SignUtil.getBack(this.getSign().getBlock());
            Block pipe = this.getBackBlock().getRelative(back);
            RangedCollectEvent event = new RangedCollectEvent(pipe, (Item)entity, new ArrayList<ItemStack>(Collections.singletonList(stack)), this.getBackBlock());
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) continue;
            if (event.getItems().isEmpty()) {
                entity.remove();
                return true;
            }
            itemsForChest.add((Item)entity);
        }
        if (!itemsForChest.isEmpty()) {
            if (!InventoryUtil.doesBlockHaveInventory(this.chest)) {
                return false;
            }
            InventoryHolder chestState = (InventoryHolder)this.chest.getState();
            for (Item entity : itemsForChest) {
                ItemStack stack = entity.getItemStack();
                List<ItemStack> leftovers = InventoryUtil.addItemsToInventory(chestState, false, stack);
                if (leftovers.isEmpty()) {
                    entity.remove();
                } else if (ItemUtil.areItemsIdentical(leftovers.get(0), stack) && leftovers.get(0).getAmount() != stack.getAmount()) {
                    entity.setItemStack(leftovers.get(0));
                }
                collected = true;
            }
        }
        return collected;
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new RangedCollector(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Collects items at a range into above chest.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"radius=x:y:z offset", "{-}id:data{,id:data}"};
        }
    }
}

