/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.world.items;

import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.entity.Item;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.util.ItemUtil;

public class ItemFan
extends AbstractSelfTriggeredIC {
    double force;

    public ItemFan(Server server, BukkitChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public void load() {
        try {
            this.force = Double.parseDouble(this.getLine(2));
        }
        catch (Exception ignored) {
            this.force = 1.0;
        }
    }

    @Override
    public String getTitle() {
        return "Item Fan";
    }

    @Override
    public String getSignTitle() {
        return "ITEM FAN";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.push());
        }
    }

    @Override
    public void think(ChipState state) {
        state.setOutput(0, this.push());
    }

    public boolean push() {
        boolean returnValue = false;
        Block aboveBlock = this.getBackBlock().getRelative(0, 1, 0);
        for (Item item : ItemUtil.getItemsAtBlock(aboveBlock)) {
            item.teleport(item.getLocation().add(0.0, this.force, 0.0));
            returnValue = true;
        }
        return returnValue;
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new ItemFan(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Gently pushes items upwards.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"force (default 1)", null};
        }
    }
}

