/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.world.items;

import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.inventory.ItemStack;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractIC;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.mechanics.ic.RestrictedIC;
import org.enginehub.craftbook.util.ItemSyntax;
import org.enginehub.craftbook.util.ItemUtil;

public class ItemDispenser
extends AbstractIC {
    private ItemStack item;
    private int times = 1;

    public ItemDispenser(Server server, BukkitChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public void load() {
        int amount = 1;
        this.item = ItemUtil.makeItemValid(ItemSyntax.getItem(this.getLine(2)));
        if (this.item == null) {
            this.item = new ItemStack(Material.STONE, 1);
        }
        try {
            amount = Math.max(1, Integer.parseInt(this.getLine(3)));
        }
        catch (Exception ignored) {
            amount = 1;
        }
        if (amount < 1) {
            amount = 1;
        }
        if (amount > this.item.getMaxStackSize()) {
            this.times = amount;
            amount = 1;
        }
        this.item.setAmount(amount);
    }

    @Override
    public String getTitle() {
        return "Item Dispenser";
    }

    @Override
    public String getSignTitle() {
        return "ITEM DISPENSER";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            Location loc = this.getBackBlock().getRelative(0, 1, 0).getLocation().add(0.5, 0.5, 0.5);
            int maxY = 10;
            for (int y = 0; y <= maxY; ++y) {
                if (loc.getBlock().getRelative(0, y, 0).getType().isSolid()) continue;
                for (int i = 0; i < this.times; ++i) {
                    this.getBackBlock().getWorld().dropItem(loc.getBlock().getRelative(0, y, 0).getLocation(), this.item.clone());
                }
                return;
            }
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new ItemDispenser(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Spawns in items.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"id:data", "amount"};
        }
    }
}

