/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.world.items;

import java.util.ArrayList;
import java.util.Collections;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.mechanics.ic.ICVerificationException;
import org.enginehub.craftbook.mechanics.ic.PipeInputIC;
import org.enginehub.craftbook.mechanics.pipe.PipePutEvent;
import org.enginehub.craftbook.mechanics.pipe.PipeRequestEvent;
import org.enginehub.craftbook.util.ItemUtil;
import org.enginehub.craftbook.util.RegexUtil;
import org.enginehub.craftbook.util.SignUtil;

public class Distributer
extends AbstractSelfTriggeredIC
implements PipeInputIC {
    Block chestBlock;
    int right;
    int left;
    int currentIndex;

    public Distributer(Server server, BukkitChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public void load() {
        try {
            this.currentIndex = Integer.parseInt(this.getLine(3));
        }
        catch (Exception e) {
            this.currentIndex = -1;
        }
        this.left = Integer.parseInt(RegexUtil.COLON_PATTERN.split(this.getLine(2))[0]);
        this.right = Integer.parseInt(RegexUtil.COLON_PATTERN.split(this.getLine(2))[1]);
        this.chestBlock = this.getBackBlock().getRelative(0, 1, 0);
    }

    @Override
    public String getTitle() {
        return "Distributer";
    }

    @Override
    public String getSignTitle() {
        return "DISTRIBUTER";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.distribute());
        }
    }

    @Override
    public void think(ChipState state) {
        state.setOutput(0, this.distribute());
    }

    public boolean distribute() {
        boolean returnValue = false;
        for (Item item : ItemUtil.getItemsAtBlock(this.getSign().getBlock())) {
            if (!this.distributeItemStack(item.getItemStack())) continue;
            item.remove();
            returnValue = true;
        }
        return returnValue;
    }

    public boolean distributeItemStack(ItemStack item) {
        BlockFace back = SignUtil.getBack(this.getSign().getBlock());
        Block b = this.goRight() ? SignUtil.getRightBlock(this.getSign().getBlock()).getRelative(back) : SignUtil.getLeftBlock(this.getSign().getBlock()).getRelative(back);
        PipeRequestEvent event = new PipeRequestEvent(b, new ArrayList<ItemStack>(Collections.singletonList(item)), this.getBackBlock());
        Bukkit.getPluginManager().callEvent((Event)event);
        for (ItemStack it : event.getItems()) {
            b.getWorld().dropItemNaturally(b.getLocation().add(0.5, 0.5, 0.5), it);
        }
        return true;
    }

    public boolean goRight() {
        ++this.currentIndex;
        this.getSign().setLine(3, (Component)Component.text((int)this.currentIndex));
        if (this.currentIndex >= this.left && this.currentIndex < this.left + this.right) {
            return true;
        }
        if (this.currentIndex < this.left) {
            return false;
        }
        this.currentIndex = 0;
        this.getSign().setLine(3, (Component)Component.text((int)this.currentIndex));
        return false;
    }

    @Override
    public void onPipeTransfer(PipePutEvent event) {
        ArrayList<ItemStack> leftovers = new ArrayList<ItemStack>();
        for (ItemStack item : event.getItems()) {
            if (!ItemUtil.isStackValid(item) || this.distributeItemStack(item)) continue;
            leftovers.add(item);
        }
        event.setItems(leftovers);
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new Distributer(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Distributes items to right and left based on sign.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"left quantity:right quantity", "Current distribution status"};
        }

        @Override
        public void verify(BukkitChangedSign sign) throws ICVerificationException {
            try {
                String line2 = PlainTextComponentSerializer.plainText().serialize(sign.getLine(2));
                Integer.parseInt(RegexUtil.COLON_PATTERN.split(line2)[0]);
                Integer.parseInt(RegexUtil.COLON_PATTERN.split(line2)[1]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new ICVerificationException("You need to specify both left and right quantities!");
            }
            catch (NumberFormatException e) {
                throw new ICVerificationException("Invalid quantities!");
            }
        }
    }
}

