/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.world.items;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Dispenser;
import org.bukkit.block.Dropper;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.material.Directional;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.mechanics.crafting.CustomCrafting;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.mechanics.ic.PipeInputIC;
import org.enginehub.craftbook.mechanics.pipe.PipePutEvent;
import org.enginehub.craftbook.mechanics.pipe.PipeRequestEvent;
import org.enginehub.craftbook.util.ItemUtil;
import org.enginehub.craftbook.util.VerifyUtil;

public class AutomaticCrafter
extends AbstractSelfTriggeredIC
implements PipeInputIC {
    private static boolean hasWarned = false;
    private static boolean hasWarnedNoResult = false;
    private Recipe recipe;

    public AutomaticCrafter(Server server, BukkitChangedSign block, ICFactory factory) {
        super(server, block, factory);
    }

    @Override
    public String getTitle() {
        return "Automatic Crafter";
    }

    @Override
    public String getSignTitle() {
        return "AUTO CRAFT";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.doStuff(true, true));
        }
    }

    @Override
    public void think(ChipState state) {
        state.setOutput(0, this.doStuff(true, true));
    }

    private void computeRecipe(InventoryHolder disp) {
        Iterator recipes = Bukkit.recipeIterator();
        try {
            while (recipes.hasNext()) {
                Recipe temprecipe = (Recipe)recipes.next();
                if (!this.isValidRecipe(temprecipe, disp.getInventory())) continue;
                this.recipe = temprecipe;
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            disp.getInventory().setContents(disp.getInventory().getContents());
        }
    }

    public boolean craft(InventoryHolder disp) {
        Inventory inv = disp.getInventory();
        for (ItemStack it : inv.getContents()) {
            if (!ItemUtil.isStackValid(it) || it.getAmount() >= 2) continue;
            return false;
        }
        if (this.recipe == null) {
            this.computeRecipe(disp);
        }
        if (this.recipe == null) {
            return false;
        }
        if (!this.isValidRecipe(this.recipe, inv)) {
            this.recipe = null;
            return this.craft(disp);
        }
        ItemStack result = CustomCrafting.craftItem(this.recipe);
        if (!ItemUtil.isStackValid(result)) {
            if (!hasWarnedNoResult) {
                CraftBook.LOGGER.warn("An Automatic Crafter IC had a valid recipe, but there was no result! This means Bukkit has an invalid recipe! Result: " + String.valueOf(result));
                hasWarnedNoResult = true;
            }
            return false;
        }
        List<ItemStack> items = new ArrayList<ItemStack>();
        ItemStack[] replace = new ItemStack[9];
        for (int i = 0; i < disp.getInventory().getContents().length; ++i) {
            if (disp.getInventory().getContents()[i] == null) continue;
            replace[i] = new ItemStack(disp.getInventory().getContents()[i]);
            if (replace[i].getType() == Material.WATER_BUCKET || replace[i].getType() == Material.LAVA_BUCKET || replace[i].getType() == Material.MILK_BUCKET) {
                items.add(new ItemStack(Material.BUCKET, 1));
            }
            replace[i].setAmount(replace[i].getAmount() - 1);
        }
        disp.getInventory().clear();
        CraftBookPlugin.logDebugMessage("AutoCrafter is dispensing a " + result.getType().name() + " with data: " + result.getDurability() + " and amount: " + result.getAmount(), "ic-mc1219");
        items.add(result);
        Block pipe = ((BlockState)disp).getBlock().getRelative(((Directional)((BlockState)disp).getData()).getFacing());
        Block base = ((BlockState)disp).getBlock();
        PipeRequestEvent event = new PipeRequestEvent(pipe, items, base);
        Bukkit.getPluginManager().callEvent((Event)event);
        items = event.getItems();
        if (!items.isEmpty()) {
            for (ItemStack stack : items) {
                if (!disp.getInventory().addItem(new ItemStack[]{stack}).isEmpty()) continue;
                for (int i = 0; i < stack.getAmount(); ++i) {
                    if (disp instanceof Dispenser) {
                        ((Dispenser)disp).dispense();
                        continue;
                    }
                    if (!(disp instanceof Dropper)) continue;
                    ((Dropper)disp).drop();
                }
            }
        }
        disp.getInventory().setContents(replace);
        return true;
    }

    private boolean collect(InventoryHolder disp) {
        if (this.recipe == null) {
            this.computeRecipe(disp);
            if (this.recipe == null) {
                return false;
            }
        }
        for (Item item : ItemUtil.getItemsAtBlock(this.getSign().getBlock())) {
            ItemStack it;
            boolean delete = true;
            ItemStack stack = item.getItemStack();
            int newAmount = stack.getAmount();
            for (int i = 0; i < stack.getAmount() && (it = ItemUtil.getSmallestStackOfType(disp.getInventory().getContents(), stack)) != null; ++i) {
                if (it.getAmount() < 64) {
                    it.setAmount(it.getAmount() + 1);
                    --newAmount;
                    continue;
                }
                if (newAmount <= 0) continue;
                delete = false;
                break;
            }
            if (newAmount > 0) {
                delete = false;
            }
            if (delete) {
                item.remove();
                continue;
            }
            stack.setAmount(newAmount);
            item.setItemStack(stack);
        }
        return false;
    }

    private boolean doStuff(boolean craft, boolean collect) {
        boolean ret = false;
        Block crafter = this.getBackBlock().getRelative(0, 1, 0);
        if (crafter.getType() == Material.DISPENSER || crafter.getType() == Material.DROPPER) {
            if (collect) {
                ret = this.collect((InventoryHolder)crafter.getState());
            }
            if (craft) {
                ret = this.craft((InventoryHolder)crafter.getState());
            }
        }
        return ret;
    }

    private boolean isValidRecipe(Recipe r, Inventory inv) {
        if (r instanceof ShapedRecipe && (this.recipe == null || this.recipe instanceof ShapedRecipe)) {
            ShapedRecipe shape = (ShapedRecipe)r;
            Map ingredientMap = shape.getIngredientMap();
            String[] shapeArr = shape.getShape();
            if (shape.getShape().length != shapeArr.length || shapeArr[0].length() != shape.getShape()[0].length()) {
                return false;
            }
            int c = -1;
            int in = 0;
            int validRecipeItems = 0;
            for (int slot = 0; slot < 9; ++slot) {
                ItemStack stack = inv.getItem(slot);
                try {
                    if (++c >= 3) {
                        c = 0;
                        if (++in >= 3) break;
                    }
                    String shapeSection = in < shapeArr.length ? shapeArr[in] : "   ";
                    ItemStack require = null;
                    try {
                        Character item = c < shapeSection.length() ? Character.valueOf(shapeSection.charAt(c)) : Character.valueOf(' ');
                        require = item.charValue() == ' ' ? null : (ItemStack)ingredientMap.get(item);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (require != null && require.getType() != Material.AIR) {
                        ++validRecipeItems;
                    }
                    if (ItemUtil.areItemsIdentical(require, stack)) continue;
                    return false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
            if (validRecipeItems == 0) {
                if (!hasWarned) {
                    CraftBook.LOGGER.warn("Found invalid recipe! This is an issue with Bukkit/Spigot/etc, please report to them. All recipe ingredients are air. Recipe result: " + r.getResult().toString());
                    hasWarned = true;
                }
                return false;
            }
            return true;
        }
        if (r instanceof ShapelessRecipe && (this.recipe == null || this.recipe instanceof ShapelessRecipe)) {
            if (((ShapelessRecipe)r).getKey().getKey().equals("shulker_box_coloring")) {
                return false;
            }
            ShapelessRecipe shape = (ShapelessRecipe)r;
            ArrayList ing = new ArrayList(VerifyUtil.withoutNulls(shape.getIngredientList()));
            if (ing.isEmpty()) {
                return false;
            }
            block5: for (ItemStack it : inv.getContents()) {
                if (!ItemUtil.isStackValid(it)) continue;
                if (ing.isEmpty()) {
                    return false;
                }
                Iterator ingIterator = ing.iterator();
                while (ingIterator.hasNext() && !ing.isEmpty()) {
                    ItemStack stack = (ItemStack)ingIterator.next();
                    if (!ItemUtil.isStackValid(stack)) {
                        ingIterator.remove();
                        continue;
                    }
                    if (!ItemUtil.areItemsIdentical(it, stack)) continue;
                    ingIterator.remove();
                    continue block5;
                }
            }
            return ing.isEmpty();
        }
        return false;
    }

    @Override
    public void onPipeTransfer(PipePutEvent event) {
        Block crafter = this.getBackBlock().getRelative(0, 1, 0);
        if (crafter.getType() == Material.DISPENSER || crafter.getType() == Material.DROPPER) {
            InventoryHolder disp = (InventoryHolder)crafter.getState();
            boolean delete = true;
            ArrayList<ItemStack> newItems = new ArrayList<ItemStack>(event.getItems());
            for (ItemStack ite : event.getItems()) {
                if (!ItemUtil.isStackValid(ite)) continue;
                int iteind = newItems.indexOf(ite);
                int newAmount = ite.getAmount();
                for (int i = 0; i < ite.getAmount(); ++i) {
                    ItemStack it = ItemUtil.getSmallestStackOfType(disp.getInventory().getContents(), ite);
                    if (!ItemUtil.isStackValid(it) || !ItemUtil.areItemsIdentical(ite, it)) continue;
                    if (it.getAmount() < 64) {
                        it.setAmount(it.getAmount() + 1);
                        --newAmount;
                        continue;
                    }
                    if (newAmount <= 0) continue;
                    delete = false;
                    break;
                }
                if (newAmount > 0) {
                    delete = false;
                }
                if (newAmount != ite.getAmount()) {
                    ite.setAmount(newAmount);
                }
                if (delete) {
                    newItems.remove(iteind);
                    continue;
                }
                newItems.set(iteind, ite);
            }
            event.getItems().clear();
            event.setItems(newItems);
        }
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new AutomaticCrafter(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Auto-crafts recipes in the above dispenser/dropper.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{null, null};
        }
    }
}

