/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.world.entity;

import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.mechanics.ic.ICVerificationException;
import org.enginehub.craftbook.util.HistoryHashMap;
import org.enginehub.craftbook.util.PlayerType;
import org.enginehub.craftbook.util.RegexUtil;
import org.enginehub.craftbook.util.SearchArea;
import org.enginehub.craftbook.util.Tuple2;

public class TeleportTransmitter
extends AbstractSelfTriggeredIC {
    protected static final HistoryHashMap<String, Tuple2<Long, String>> memory = new HistoryHashMap(50);
    protected static HistoryHashMap<String, Location> lastKnownLocations = new HistoryHashMap(50);
    protected String band;
    SearchArea area;
    PlayerType type;
    String typeData;

    public TeleportTransmitter(Server server, BukkitChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public String getTitle() {
        return "Teleport Transmitter";
    }

    @Override
    public String getSignTitle() {
        return "TELEPORT OUT";
    }

    @Override
    public void load() {
        this.band = RegexUtil.PIPE_PATTERN.split(this.getLine(2))[0];
        if (this.getLine(2).contains("|")) {
            this.type = PlayerType.getFromChar(RegexUtil.PIPE_PATTERN.split(this.getLine(2))[1].charAt(0));
            this.typeData = RegexUtil.COLON_PATTERN.split(RegexUtil.PIPE_PATTERN.split(this.getLine(2))[1])[1];
        }
        this.area = SearchArea.createArea(this.getSign().getBlock(), this.getLine(3));
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.sendPlayer());
        }
    }

    @Override
    public void think(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.sendPlayer());
        }
    }

    public boolean sendPlayer() {
        Player closest = null;
        for (Player e : this.area.getPlayersInArea()) {
            if (e == null || !e.isValid() || e.isDead() || this.type != null && !this.type.doesPlayerPass(e, this.typeData)) continue;
            if (closest == null) {
                closest = e;
            }
            if (this.area.getCenter() == null) break;
            if (closest.getWorld() != this.area.getWorld() || !(closest.getLocation().distanceSquared(this.area.getCenter()) >= e.getLocation().distanceSquared(this.area.getCenter()))) continue;
            closest = e;
        }
        if (closest != null && lastKnownLocations.containsKey(this.band)) {
            ((Location)lastKnownLocations.get(this.band)).getChunk().load();
        }
        if (closest == null || TeleportTransmitter.setValue(this.band, new Tuple2<Long, String>(System.currentTimeMillis(), closest.getName()))) {
            return true;
        }
        closest.sendMessage(String.valueOf(ChatColor.RED) + "This Teleporter Frequency is currently busy! Try again soon (3s)!");
        return false;
    }

    public static Tuple2<Long, String> getValue(String band) {
        long time;
        int seconds;
        if (memory.containsKey(band) && (seconds = (int)((time = System.currentTimeMillis() - (Long)((Tuple2)memory.get(band)).left()) / 1000L) % 60) > 5) {
            memory.remove(band);
            return null;
        }
        Tuple2 val = (Tuple2)memory.get(band);
        memory.remove(band);
        return val;
    }

    public static boolean setValue(String band, Tuple2<Long, String> val) {
        if (memory.containsKey(band)) {
            long time = System.currentTimeMillis() - (Long)((Tuple2)memory.get(band)).left();
            int seconds = (int)(time / 1000L) % 60;
            if (seconds > 3) {
                memory.remove(band);
            } else {
                return false;
            }
        }
        memory.put(band, val);
        return true;
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new TeleportTransmitter(this.getServer(), sign, this);
        }

        @Override
        public String[] getLongDescription() {
            return new String[]{"The '''MC1112''' teleports a player located within IC's radius to a receiver ([[../MC1113/]]) tuned to the same ''frequency''.", "This IC requires the recieving chunk to be loaded for the initial teleport, future teleports should not require the chunk to be loaded."};
        }

        @Override
        public String getShortDescription() {
            return "Transmitter for the teleportation network.";
        }

        @Override
        public String[] getPinDescription(ChipState state) {
            return new String[]{"Trigger IC", "High on successful teleport queue"};
        }

        @Override
        public void verify(BukkitChangedSign sign) throws ICVerificationException {
            if (!SearchArea.isValidArea(sign.getBlock(), PlainTextComponentSerializer.plainText().serialize(sign.getLine(3)))) {
                throw new ICVerificationException("Invalid SearchArea on 4th line!");
            }
        }

        @Override
        public void load() {
        }

        @Override
        public void unload() {
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"Frequency|PlayerType", "SearchArea"};
        }
    }
}

