/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.world.entity;

import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.mechanics.ic.gates.world.entity.TeleportTransmitter;
import org.enginehub.craftbook.util.Tuple2;

public class TeleportReciever
extends AbstractSelfTriggeredIC {
    String band;
    String welcome;

    public TeleportReciever(Server server, BukkitChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public String getTitle() {
        return "Teleport Reciever";
    }

    @Override
    public String getSignTitle() {
        return "TELEPORT IN";
    }

    @Override
    public void load() {
        this.band = this.getLine(2);
        this.welcome = this.getLine(3);
        if (this.welcome == null || this.welcome.isEmpty()) {
            this.welcome = "The Teleporter moves you here...";
        }
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.check());
        }
    }

    @Override
    public void think(ChipState chip) {
        if (!chip.getInput(0)) {
            chip.setOutput(0, this.check());
        }
    }

    public boolean check() {
        Tuple2<Long, String> val = TeleportTransmitter.getValue(this.band);
        if (val == null) {
            return false;
        }
        Player p = Bukkit.getServer().getPlayerExact(val.right());
        if (p == null || !p.isOnline()) {
            return false;
        }
        Block block = this.getBackBlock();
        while (block.getType().isSolid()) {
            block = block.getRelative(0, 1, 0);
        }
        p.teleport(block.getLocation().add(0.5, 0.5, 0.5));
        CraftBookPlugin.inst().wrapPlayer(p).print(this.welcome);
        TeleportTransmitter.lastKnownLocations.put(this.band, block.getLocation());
        return true;
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new TeleportReciever(this.getServer(), sign, this);
        }

        @Override
        public String[] getLongDescription() {
            return new String[]{"The '''MC1113''' will teleport a player from a corresponding [[../MC1112/]] IC on a redstone signal."};
        }

        @Override
        public String getShortDescription() {
            return "Reciever for the teleportation network.";
        }

        @Override
        public String[] getPinDescription(ChipState state) {
            return new String[]{"Trigger IC (When ST, disables IC when high)", "High on successful teleport"};
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"Frequency", "+oWelcome Text"};
        }
    }
}

