/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.world.entity;

import net.kyori.adventure.text.Component;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.mechanics.ic.RestrictedIC;
import org.enginehub.craftbook.util.PlayerType;
import org.enginehub.craftbook.util.RegexUtil;
import org.enginehub.craftbook.util.SearchArea;

public class PlayerTrap
extends AbstractSelfTriggeredIC {
    SearchArea area;
    int damage;
    PlayerType type;
    String nameLine;

    public PlayerTrap(Server server, BukkitChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public String getTitle() {
        return "Player Trap";
    }

    @Override
    public String getSignTitle() {
        return "PLAYER TRAP";
    }

    @Override
    public void load() {
        if (this.getLine(2).contains("&")) {
            this.getSign().setLine(2, (Component)Component.text((String)this.getLine(2).replace("&", "=")));
            this.getSign().update(false);
        }
        this.area = SearchArea.createArea(this.getSign().getBlock(), RegexUtil.EQUALS_PATTERN.split(this.getLine(2))[0]);
        try {
            this.damage = Integer.parseInt(RegexUtil.EQUALS_PATTERN.split(this.getLine(2))[1]);
        }
        catch (Exception ignored) {
            this.damage = 2;
        }
        this.type = this.getLine(3).contains(":") ? PlayerType.getFromChar(this.getLine(3).trim().toCharArray()[0]) : PlayerType.ALL;
        this.nameLine = this.getLine(3).replace("g:", "").replace("p:", "").replace("n:", "").replace("t:", "").replace("a:", "").trim();
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.hurt());
        }
    }

    public boolean hurt() {
        boolean hasHurt = false;
        for (Player p : this.area.getPlayersInArea()) {
            if (!this.type.doesPlayerPass(p, this.nameLine)) continue;
            p.damage((double)this.damage);
            hasHurt = true;
        }
        return hasHurt;
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new PlayerTrap(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Damages nearby players that fit criteria.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"SearchArea=damage", "PlayerType"};
        }
    }
}

