/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.world.entity;

import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.mechanics.ic.RestrictedIC;
import org.enginehub.craftbook.util.EntityType;
import org.enginehub.craftbook.util.RegexUtil;

public class EntityCannon
extends AbstractSelfTriggeredIC {
    double x;
    double y;
    double z;
    EntityType type;
    Location location;

    public EntityCannon(Server server, BukkitChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public String getTitle() {
        return "Entity Cannon";
    }

    @Override
    public String getSignTitle() {
        return "ENTITY CANNON";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.shoot());
        }
    }

    @Override
    public void think(ChipState state) {
        state.setOutput(0, this.shoot());
    }

    @Override
    public void load() {
        this.location = this.getSign().getBlock().getLocation();
        if (!this.getLine(3).isEmpty()) {
            this.type = EntityType.fromString(this.getLine(3));
        }
        if (this.type == null) {
            this.type = EntityType.MOB_HOSTILE;
        }
        try {
            String[] split = RegexUtil.COLON_PATTERN.split(this.getLine(2));
            this.x = Double.parseDouble(split[0]);
            this.y = Double.parseDouble(split[1]);
            this.z = Double.parseDouble(split[2]);
        }
        catch (Exception e) {
            this.x = 0.0;
            this.y = 1.0;
            this.z = 0.0;
        }
    }

    protected boolean shoot() {
        boolean resultBoolean = false;
        for (Entity e : this.location.getNearbyEntities(3.0, 3.0, 3.0)) {
            if (e.isDead() || !e.isValid() || !this.type.is(e)) continue;
            e.setVelocity(new Vector(this.x, this.y, this.z).add(e.getVelocity()));
            resultBoolean = true;
        }
        return resultBoolean;
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new EntityCannon(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Shoots nearby entities of type at set velocity.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"velocity x:y:z", "mob type"};
        }
    }
}

