/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.world.entity;

import java.util.Locale;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Skeleton;
import org.bukkit.inventory.ItemStack;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractIC;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.mechanics.ic.ICVerificationException;
import org.enginehub.craftbook.mechanics.ic.RestrictedIC;
import org.enginehub.craftbook.util.EntityUtil;
import org.enginehub.craftbook.util.LocationUtil;
import org.enginehub.craftbook.util.RegexUtil;

public class CreatureSpawner
extends AbstractIC {
    EntityType type;
    String data;
    int amount;

    public CreatureSpawner(Server server, BukkitChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public void load() {
        this.type = EntityType.fromName((String)this.getLine(2).trim().toLowerCase(Locale.ENGLISH));
        if (this.type == null) {
            this.type = EntityType.valueOf((String)this.getLine(2).trim().toUpperCase(Locale.ENGLISH));
            if (this.type == null) {
                this.type = EntityType.PIG;
            }
        }
        String line = this.getLine(3).trim();
        try {
            String[] entityInf = RegexUtil.ASTERISK_PATTERN.split(line, 2);
            this.data = entityInf[0];
            this.amount = Integer.parseInt(entityInf[1]);
        }
        catch (Exception e) {
            this.amount = 1;
            this.data = line;
        }
    }

    @Override
    public String getTitle() {
        return "Creature Spawner";
    }

    @Override
    public String getSignTitle() {
        return "CREATURE SPAWNER";
    }

    @Override
    public void trigger(ChipState chip) {
        Block center = this.getBackBlock();
        if (!center.getChunk().isLoaded()) {
            return;
        }
        if (chip.getInput(0)) {
            if (center.getRelative(0, 1, 0).getType() == Material.SPAWNER) {
                org.bukkit.block.CreatureSpawner sp = (org.bukkit.block.CreatureSpawner)center.getRelative(0, 1, 0).getState();
                sp.setSpawnedType(this.type);
                sp.update();
            } else {
                Location loc = LocationUtil.getBlockCentreTop(LocationUtil.getNextFreeSpace(center, BlockFace.UP));
                for (int i = 0; i < this.amount; ++i) {
                    Entity entity = loc.getWorld().spawn(loc, this.type.getEntityClass());
                    if (entity instanceof Skeleton) {
                        ((Skeleton)entity).getEquipment().setItemInHand(new ItemStack(Material.BOW, 1));
                    }
                    EntityUtil.setEntityData(entity, this.data);
                }
            }
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new CreatureSpawner(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Spawns a mob with specified data.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"entitytype", "+odata*amount"};
        }

        @Override
        public void verify(BukkitChangedSign sign) throws ICVerificationException {
            String line2 = PlainTextComponentSerializer.plainText().serialize(sign.getLine(2));
            EntityType type = EntityType.fromName((String)line2.trim().toLowerCase(Locale.ENGLISH));
            if (type == null) {
                type = EntityType.valueOf((String)line2.trim().toUpperCase(Locale.ENGLISH));
            }
            if (type == null) {
                throw new ICVerificationException("Invalid Entity! See bukkit EntityType list!");
            }
            if (!type.isSpawnable()) {
                throw new ICVerificationException("Entity is not spawnable!");
            }
        }
    }
}

