/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.world.entity;

import java.util.Collections;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Chest;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Cow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Sheep;
import org.bukkit.inventory.ItemStack;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.util.EntityType;
import org.enginehub.craftbook.util.ItemUtil;
import org.enginehub.craftbook.util.SearchArea;

public class AnimalHarvester
extends AbstractSelfTriggeredIC {
    private SearchArea area;
    private Block chest;

    public AnimalHarvester(Server server, BukkitChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public void load() {
        this.area = SearchArea.createArea(this.getSign().getBlock(), this.getLine(2));
        this.chest = this.getBackBlock().getRelative(BlockFace.UP);
    }

    @Override
    public String getTitle() {
        return "Animal Harvester";
    }

    @Override
    public String getSignTitle() {
        return "ANIMAL HARVEST";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.harvest());
        }
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public void think(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.harvest());
        }
    }

    public boolean harvest() {
        for (Entity entity : this.area.getEntitiesInArea(Collections.singletonList(EntityType.MOB_PEACEFUL))) {
            if (!entity.isValid() || !(entity instanceof Cow) && !(entity instanceof Sheep) || !((Animals)entity).isAdult() || !this.canHarvest(entity)) continue;
            return this.harvestAnimal(entity);
        }
        return false;
    }

    public boolean canHarvest(Entity entity) {
        if (entity instanceof Cow && this.doesChestContain(Material.BUCKET)) {
            return true;
        }
        if (entity instanceof Sheep && this.doesChestContain(Material.SHEARS)) {
            Sheep sh = (Sheep)entity;
            return !sh.isSheared();
        }
        return false;
    }

    public boolean harvestAnimal(Entity entity) {
        if (entity instanceof Cow && this.doesChestContain(Material.BUCKET)) {
            this.removeFromChest(Material.BUCKET);
            if (!this.addToChest(new ItemStack(Material.MILK_BUCKET, 1))) {
                this.addToChest(new ItemStack(Material.BUCKET, 1));
                return false;
            }
            return true;
        }
        if (entity instanceof Sheep && this.doesChestContain(Material.SHEARS)) {
            Sheep sh = (Sheep)entity;
            if (sh.isSheared()) {
                return false;
            }
            if (this.addToChest(new ItemStack(ItemUtil.getWoolFromColour(sh.getColor()), ThreadLocalRandom.current().nextInt(2) + 1))) {
                sh.setSheared(true);
                return true;
            }
        }
        return false;
    }

    public boolean doesChestContain(Material item) {
        if (this.chest.getType() == Material.CHEST) {
            Chest c = (Chest)this.chest.getState();
            return c.getInventory().contains(item);
        }
        return false;
    }

    public boolean addToChest(ItemStack item) {
        if (this.chest.getType() == Material.CHEST) {
            Chest c = (Chest)this.chest.getState();
            return c.getInventory().addItem(new ItemStack[]{item}).isEmpty();
        }
        return false;
    }

    public boolean removeFromChest(Material item) {
        if (this.chest.getType() == Material.CHEST) {
            Chest c = (Chest)this.chest.getState();
            return c.getInventory().removeItem(new ItemStack[]{new ItemStack(item, 1)}).isEmpty();
        }
        return false;
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new AnimalHarvester(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Harvests nearby cows and sheep.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"+oSearchArea", null};
        }
    }
}

