/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.world.entity;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.Cow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Pig;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Wolf;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.util.InventoryUtil;
import org.enginehub.craftbook.util.SearchArea;

public class AnimalBreeder
extends AbstractSelfTriggeredIC {
    private SearchArea area;
    private Block chest;
    private Map<EntityType, Entity> lastEntity = new HashMap<EntityType, Entity>();

    public AnimalBreeder(Server server, BukkitChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public void load() {
        this.area = SearchArea.createArea(this.getSign().getBlock(), this.getLine(2));
        this.chest = this.getBackBlock().getRelative(BlockFace.UP);
    }

    @Override
    public String getTitle() {
        return "Animal Breeder";
    }

    @Override
    public String getSignTitle() {
        return "ANIMAL BREEDER";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.breed());
        }
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public void think(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.breed());
        }
    }

    @Override
    public void unload() {
        this.lastEntity.clear();
    }

    public boolean breed() {
        this.lastEntity.clear();
        InventoryHolder inv = null;
        if (InventoryUtil.doesBlockHaveInventory(this.chest)) {
            inv = (InventoryHolder)this.chest.getState();
        }
        if (inv == null) {
            return false;
        }
        for (Entity entity : this.area.getEntitiesInArea(Collections.singletonList(org.enginehub.craftbook.util.EntityType.MOB_PEACEFUL))) {
            if (!entity.isValid() || !(entity instanceof Ageable) || !((Ageable)entity).canBreed() || !this.canBreed(entity)) continue;
            if (this.breedAnimal(inv, entity)) {
                return true;
            }
            this.lastEntity.put(entity.getType(), entity);
        }
        return false;
    }

    public boolean canBreed(Entity entity) {
        return entity instanceof Cow || entity instanceof Sheep || entity instanceof Pig || entity instanceof Chicken || entity instanceof Wolf;
    }

    public boolean breedAnimal(InventoryHolder inv, Entity entity) {
        if (this.lastEntity.get(entity.getType()) != null) {
            if (entity instanceof Cow || entity instanceof Sheep) {
                if (InventoryUtil.doesInventoryContain(inv.getInventory(), false, new ItemStack(Material.WHEAT, 2)) && InventoryUtil.removeItemsFromInventory(inv, new ItemStack(Material.WHEAT, 2))) {
                    Ageable animal = (Ageable)entity.getWorld().spawnEntity(entity.getLocation(), entity.getType());
                    animal.setBaby();
                    ((Ageable)entity).setBreed(false);
                    if (entity instanceof Sheep && animal instanceof Sheep) {
                        ((Sheep)animal).setColor(((Sheep)entity).getColor());
                    }
                    return true;
                }
            } else if (entity instanceof Pig) {
                if (InventoryUtil.doesInventoryContain(inv.getInventory(), false, new ItemStack(Material.CARROT, 2)) && InventoryUtil.removeItemsFromInventory(inv, new ItemStack(Material.CARROT, 2))) {
                    Ageable animal = (Ageable)entity.getWorld().spawnEntity(entity.getLocation(), entity.getType());
                    animal.setBaby();
                    ((Ageable)entity).setBreed(false);
                    return true;
                }
            } else if (entity instanceof Chicken) {
                if (InventoryUtil.doesInventoryContain(inv.getInventory(), false, new ItemStack(Material.WHEAT_SEEDS, 2)) && InventoryUtil.removeItemsFromInventory(inv, new ItemStack(Material.WHEAT_SEEDS, 2))) {
                    Ageable animal = (Ageable)entity.getWorld().spawnEntity(entity.getLocation(), entity.getType());
                    animal.setBaby();
                    ((Ageable)entity).setBreed(false);
                    return true;
                }
            } else if (entity instanceof Wolf) {
                Material[] validItems;
                for (Material item : validItems = new Material[]{Material.CHICKEN, Material.COOKED_CHICKEN, Material.BEEF, Material.COOKED_BEEF, Material.PORKCHOP, Material.COOKED_PORKCHOP, Material.ROTTEN_FLESH}) {
                    if (!InventoryUtil.doesInventoryContain(inv.getInventory(), false, new ItemStack(item, 2)) || !InventoryUtil.removeItemsFromInventory(inv, new ItemStack(item, 2))) continue;
                    Ageable animal = (Ageable)entity.getWorld().spawnEntity(entity.getLocation(), entity.getType());
                    animal.setBaby();
                    ((Ageable)entity).setBreed(false);
                    return true;
                }
            }
        }
        return false;
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new AnimalBreeder(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Breeds nearby animals.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"+oSearchArea", null};
        }
    }
}

