/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.world.entity;

import java.util.Locale;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.sign.Side;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractIC;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.mechanics.ic.ICVerificationException;
import org.enginehub.craftbook.mechanics.ic.RestrictedIC;
import org.enginehub.craftbook.util.EntityUtil;
import org.enginehub.craftbook.util.ICUtil;
import org.enginehub.craftbook.util.ItemSyntax;
import org.enginehub.craftbook.util.ItemUtil;
import org.enginehub.craftbook.util.RegexUtil;
import org.enginehub.craftbook.util.SignUtil;

public class AdvancedEntitySpawner
extends AbstractIC {
    private Location location;
    private EntityType type;
    private int amount;

    public AdvancedEntitySpawner(Server server, BukkitChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public String getTitle() {
        return "Advanced Entity Spawner";
    }

    @Override
    public String getSignTitle() {
        return "ADV ENT SPAWNER";
    }

    @Override
    public void load() {
        String line3 = this.getLine(3);
        String[] splitLine3 = RegexUtil.ASTERISK_PATTERN.split(line3.trim());
        try {
            this.type = EntityType.valueOf((String)splitLine3[0].trim().toLowerCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            try {
                this.type = EntityType.valueOf((String)splitLine3[0].trim().toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException ee) {
                this.type = EntityType.PIG;
            }
        }
        try {
            this.amount = Integer.parseInt(splitLine3[1]);
        }
        catch (Exception e) {
            this.amount = 1;
        }
        this.location = ICUtil.parseBlockLocation(this.getSign(), 2).getLocation();
    }

    @Override
    public void trigger(ChipState chip) {
        if (!this.location.getChunk().isLoaded()) {
            return;
        }
        if (!chip.getInput(0)) {
            return;
        }
        Block left = SignUtil.getLeftBlock(this.getSign().getBlock());
        BukkitChangedSign effectSign = null;
        if (SignUtil.isWallSign(left)) {
            effectSign = BukkitChangedSign.create(left, Side.FRONT);
        }
        Block right = SignUtil.getRightBlock(this.getSign().getBlock());
        BukkitChangedSign armourSign = null;
        if (SignUtil.isWallSign(right)) {
            armourSign = BukkitChangedSign.create(right, Side.FRONT);
        }
        block10: for (int i = 0; i < this.amount; ++i) {
            Entity ent = this.getSign().getBlock().getWorld().spawn(this.location, this.type.getEntityClass());
            if (armourSign != null && ent instanceof LivingEntity) {
                block11: for (int s = 0; s < 4; ++s) {
                    String bit = PlainTextComponentSerializer.plainText().serialize(armourSign.getLine(s));
                    ItemStack slot = ItemUtil.makeItemValid(ItemSyntax.getItem(bit));
                    switch (s) {
                        case 0: {
                            ((LivingEntity)ent).getEquipment().setHelmet(slot);
                            continue block11;
                        }
                        case 1: {
                            ((LivingEntity)ent).getEquipment().setChestplate(slot);
                            continue block11;
                        }
                        case 2: {
                            ((LivingEntity)ent).getEquipment().setLeggings(slot);
                            continue block11;
                        }
                        case 3: {
                            ((LivingEntity)ent).getEquipment().setBoots(slot);
                        }
                    }
                }
            }
            Boolean upwards = null;
            while (effectSign != null) {
                for (int s = 0; s < 4; ++s) {
                    String bit = PlainTextComponentSerializer.plainText().serialize(effectSign.getLine(s));
                    if (bit == null || bit.trim().isEmpty()) continue;
                    String[] data = RegexUtil.COLON_PATTERN.split(bit);
                    if (data[0].equalsIgnoreCase("e")) {
                        EntityUtil.setEntityData(ent, bit.substring(2));
                        continue;
                    }
                    if (data[0].equalsIgnoreCase("r")) {
                        EntityType rider = EntityType.fromName((String)data[1].trim());
                        Entity rid = this.getSign().getBlock().getWorld().spawnEntity(this.location, rider);
                        ent.setPassenger(rid);
                        continue;
                    }
                    if (data[0].equalsIgnoreCase("p") && ent instanceof LivingEntity) {
                        for (int a = 1; a < data.length; ++a) {
                            try {
                                String[] potionBits = RegexUtil.SEMICOLON_PATTERN.split(data[a]);
                                PotionEffect effect = new PotionEffect(PotionEffectType.getById((int)Integer.parseInt(potionBits[0])), Integer.parseInt(potionBits[1]), Integer.parseInt(potionBits[2]));
                                ((LivingEntity)ent).addPotionEffect(effect, true);
                                continue;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        continue;
                    }
                    if (data[0].equalsIgnoreCase("v")) {
                        try {
                            String[] coords = RegexUtil.COMMA_PATTERN.split(data[1]);
                            double x = Double.parseDouble(coords[0]);
                            double y = Double.parseDouble(coords[1]);
                            double z = Double.parseDouble(coords[2]);
                            ent.setVelocity(new Vector(x, y, z));
                        }
                        catch (Exception x) {}
                        continue;
                    }
                    if (!data[0].equalsIgnoreCase("s") || !(ent instanceof LivingEntity)) continue;
                    ItemStack slot = ItemUtil.makeItemValid(ItemSyntax.getItem(bit.replace("s:", "")));
                    ((LivingEntity)ent).getEquipment().setItemInHand(slot);
                }
                if (upwards == null) {
                    if (SignUtil.isWallSign(effectSign.getBlock().getRelative(0, 1, 0))) {
                        effectSign = BukkitChangedSign.create(effectSign.getBlock().getRelative(0, 1, 0), effectSign.getSide());
                        upwards = true;
                        continue;
                    }
                    if (!SignUtil.isWallSign(effectSign.getBlock().getRelative(0, -1, 0))) continue block10;
                    effectSign = BukkitChangedSign.create(effectSign.getBlock().getRelative(0, -1, 0), effectSign.getSide());
                    upwards = false;
                    continue;
                }
                if (!SignUtil.isWallSign(effectSign.getBlock().getRelative(0, upwards != false ? 1 : -1, 0))) continue block10;
                effectSign = BukkitChangedSign.create(effectSign.getBlock().getRelative(0, upwards != false ? 1 : -1, 0), effectSign.getSide());
            }
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new AdvancedEntitySpawner(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Spawns a mob with many customizations.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"+ox:y:z", "entitytype{*amount}"};
        }

        @Override
        public void verify(BukkitChangedSign sign) throws ICVerificationException {
            String line3 = PlainTextComponentSerializer.plainText().serialize(sign.getLine(3));
            String[] splitLine3 = RegexUtil.ASTERISK_PATTERN.split(line3.trim());
            EntityType type = EntityType.fromName((String)splitLine3[0].trim().toLowerCase(Locale.ENGLISH));
            if (type == null) {
                try {
                    EntityType.valueOf((String)splitLine3[0].trim().toUpperCase(Locale.ENGLISH));
                }
                catch (IllegalArgumentException e) {
                    throw new ICVerificationException("Invalid Entity! See bukkit EntityType list!");
                }
            } else if (!type.isSpawnable()) {
                throw new ICVerificationException("Entity is not spawnable!");
            }
        }
    }
}

