/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.world.blocks;

import com.sk89q.worldedit.math.Vector3;
import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractIC;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.mechanics.ic.RestrictedIC;
import org.enginehub.craftbook.util.ICUtil;
import org.enginehub.craftbook.util.InventoryUtil;
import org.enginehub.craftbook.util.LocationUtil;

public class Spigot
extends AbstractIC {
    private Vector3 radius;
    private Location offset;

    public Spigot(Server server, BukkitChangedSign block, ICFactory factory) {
        super(server, block, factory);
    }

    @Override
    public void load() {
        this.radius = ICUtil.parseRadius(this.getSign());
        this.offset = ICUtil.parseBlockLocation(this.getSign()).getLocation();
    }

    @Override
    public String getTitle() {
        return "Spigot";
    }

    @Override
    public String getSignTitle() {
        return "SPIGOT";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.search());
        }
    }

    public boolean search() {
        Block chest = this.getBackBlock().getRelative(0, -1, 0);
        if (InventoryUtil.doesBlockHaveInventory(chest)) {
            InventoryHolder c = (InventoryHolder)chest.getState();
            Block off = this.offset.getBlock();
            ArrayList<Location> searched = new ArrayList<Location>();
            return this.searchAt(c, searched, off);
        }
        return false;
    }

    public boolean searchAt(InventoryHolder chest, ArrayList<Location> searched, Block off) {
        if (searched.contains(off.getLocation())) {
            return false;
        }
        searched.add(off.getLocation());
        if (!LocationUtil.isWithinRadius(off.getLocation(), this.offset, this.radius)) {
            return false;
        }
        if (off.getType() == Material.AIR) {
            Material m = this.getFromChest(chest);
            if (m == Material.AIR) {
                return false;
            }
            off.setType(Spigot.unparse(m));
            return true;
        }
        if (off.isLiquid()) {
            if (off.getData() != 0) {
                Material m = this.getFromChest(chest, off.getType());
                if (m == Material.AIR) {
                    return false;
                }
                off.setType(Spigot.unparse(m));
                return true;
            }
            return this.searchAt(chest, searched, off.getRelative(1, 0, 0)) || this.searchAt(chest, searched, off.getRelative(-1, 0, 0)) || this.searchAt(chest, searched, off.getRelative(0, 0, 1)) || this.searchAt(chest, searched, off.getRelative(0, 0, -1)) || this.searchAt(chest, searched, off.getRelative(0, 1, 0)) || this.searchAt(chest, searched, off.getRelative(0, -1, 0));
        }
        return false;
    }

    public Material getFromChest(InventoryHolder holder) {
        HashMap over = holder.getInventory().removeItem(new ItemStack[]{new ItemStack(Material.WATER_BUCKET, 1)});
        if (over.isEmpty()) {
            holder.getInventory().addItem(new ItemStack[]{new ItemStack(Material.BUCKET)});
            return Material.WATER;
        }
        over = holder.getInventory().removeItem(new ItemStack[]{new ItemStack(Material.LAVA_BUCKET, 1)});
        if (over.isEmpty()) {
            holder.getInventory().addItem(new ItemStack[]{new ItemStack(Material.BUCKET)});
            return Material.LAVA;
        }
        return Material.AIR;
    }

    public Material getFromChest(InventoryHolder holder, Material m) {
        m = Spigot.parse(m);
        HashMap over = holder.getInventory().removeItem(new ItemStack[]{new ItemStack(m, 1)});
        if (over.isEmpty()) {
            holder.getInventory().addItem(new ItemStack[]{new ItemStack(Material.BUCKET)});
            return Spigot.unparse(m);
        }
        return Material.AIR;
    }

    public static Material parse(Material mat) {
        if (mat == Material.WATER || mat == Material.WATER_BUCKET) {
            return Material.WATER_BUCKET;
        }
        if (mat == Material.LAVA || mat == Material.LAVA_BUCKET) {
            return Material.LAVA_BUCKET;
        }
        return Material.AIR;
    }

    public static Material unparse(Material mat) {
        if (mat == Material.WATER_BUCKET || mat == Material.WATER) {
            return Material.WATER;
        }
        if (mat == Material.LAVA_BUCKET || mat == Material.LAVA) {
            return Material.LAVA;
        }
        return Material.AIR;
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new Spigot(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Fills areas with liquid from below chest.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"+oradius=x:y:z offset", null};
        }
    }
}

