/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.world.blocks;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractIC;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.mechanics.ic.RestrictedIC;
import org.enginehub.craftbook.util.BlockParser;
import org.enginehub.craftbook.util.BlockUtil;
import org.enginehub.craftbook.util.LocationUtil;
import org.enginehub.craftbook.util.RegexUtil;
import org.enginehub.craftbook.util.SignUtil;

public class SetBridge
extends AbstractIC {
    private BlockData onBlock;
    private BlockData offBlock;
    private int width;
    private int depth;
    private int offsetX = 0;
    private int offsetY = 1;
    private int offsetZ = 0;
    private Block center;
    private BlockFace faceing;

    public SetBridge(Server server, BukkitChangedSign block, ICFactory factory) {
        super(server, block, factory);
    }

    @Override
    public void load() {
        this.center = this.getBackBlock();
        this.faceing = SignUtil.getBack(this.getSign().getBlock());
        String line = this.getLine(2);
        if (!line.isEmpty()) {
            String[] split = RegexUtil.MINUS_PATTERN.split(line);
            if (split.length > 1) {
                this.offBlock = BukkitAdapter.adapt((BlockStateHolder)BlockParser.getBlock(split[1]));
            }
            this.onBlock = BukkitAdapter.adapt((BlockStateHolder)BlockParser.getBlock(split[0]));
        }
        if (!(line = this.getLine(3)).trim().isEmpty()) {
            boolean relativeOffset;
            boolean bl = relativeOffset = !line.contains("!");
            if (!relativeOffset) {
                line = line.trim().replace("!", "");
            }
            String[] split = RegexUtil.COLON_PATTERN.split(line);
            try {
                String[] offsetSplit = RegexUtil.COMMA_PATTERN.split(split[0]);
                this.offsetX = Integer.parseInt(offsetSplit[0]);
                this.offsetY = Integer.parseInt(offsetSplit[1]);
                this.offsetZ = Integer.parseInt(offsetSplit[2]);
            }
            catch (IndexOutOfBoundsException | NumberFormatException offsetSplit) {
                // empty catch block
            }
            try {
                String[] sizeSplit = RegexUtil.COMMA_PATTERN.split(split[1]);
                this.width = Integer.parseInt(sizeSplit[0]);
                this.depth = Integer.parseInt(sizeSplit[1]);
            }
            catch (NumberFormatException e) {
                this.width = 1;
                this.depth = 1;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.depth = 1;
            }
            this.center = relativeOffset ? LocationUtil.getRelativeOffset(this.getSign().getBlock(), this.offsetX, this.offsetY, this.offsetZ) : this.center.getRelative(this.offsetX, this.offsetY, this.offsetZ);
        } else {
            this.center = this.center.getRelative(BlockFace.UP);
        }
    }

    @Override
    public String getTitle() {
        return "Set P-Bridge";
    }

    @Override
    public String getSignTitle() {
        return "SET P-Bridge";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            this.setDoor(true);
        } else {
            this.setDoor(false);
        }
        chip.setOutput(0, chip.getInput(0));
    }

    private void setDoor(boolean open) {
        for (int x = 0; x < this.width; ++x) {
            for (int z = 0; z < this.depth; ++z) {
                Block block = LocationUtil.getRelativeOffset(this.center, this.faceing, x, 0, z);
                boolean isSource = block.equals((Object)this.getBackBlock());
                if (open) {
                    if (isSource && BlockUtil.isBlockReplacable(this.onBlock.getMaterial())) continue;
                    block.setBlockData(this.onBlock);
                    continue;
                }
                if (isSource && BlockUtil.isBlockReplacable(this.offBlock.getMaterial())) continue;
                block.setBlockData(this.offBlock);
            }
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public String getShortDescription() {
            return "Generates a bridge out of the set materials with set size.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"onID{:onData-offID:offData}", "offset x,y,z:width,depth"};
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new SetBridge(this.getServer(), sign, this);
        }
    }
}

