/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.world.blocks;

import com.google.common.collect.Lists;
import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.blocks.Blocks;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.List;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.ConfigurableIC;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.mechanics.ic.ICVerificationException;
import org.enginehub.craftbook.mechanics.ic.RestrictedIC;
import org.enginehub.craftbook.mechanics.ic.gates.world.blocks.SetBlock;
import org.enginehub.craftbook.util.BlockParser;

public class SetBlockAdmin
extends SetBlock {
    public SetBlockAdmin(Server server, BukkitChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public String getTitle() {
        return "Set Block Admin";
    }

    @Override
    public String getSignTitle() {
        return "SET BLOCK ADMIN";
    }

    @Override
    protected void doSet(Block body, BlockStateHolder blockData, boolean force) {
        BlockFace toPlace;
        if (Blocks.containsFuzzy(((Factory)this.getFactory()).blockBlacklist, (BlockStateHolder)this.item)) {
            return;
        }
        BlockFace blockFace = toPlace = ((Factory)this.getFactory()).above ? BlockFace.UP : BlockFace.DOWN;
        if (force || body.getRelative(toPlace).getType() == Material.AIR) {
            body.getRelative(toPlace).setBlockData(BukkitAdapter.adapt((BlockStateHolder)blockData));
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC,
    ConfigurableIC {
        boolean above;
        public List<BaseBlock> blockBlacklist;

        public Factory(Server server, boolean above) {
            super(server);
            this.above = above;
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new SetBlockAdmin(this.getServer(), sign, this);
        }

        @Override
        public void verify(BukkitChangedSign sign) throws ICVerificationException {
            String line2 = PlainTextComponentSerializer.plainText().serialize(sign.getLine(2));
            if (line2.isEmpty()) {
                throw new ICVerificationException("A block must be provided on line 2!");
            }
            BaseBlock item = BlockParser.getBlock(line2, true);
            if (item == null) {
                throw new ICVerificationException("An invalid block was provided on line 2!");
            }
            if (Blocks.containsFuzzy(this.blockBlacklist, (BlockStateHolder)item)) {
                throw new ICVerificationException("A blacklisted block was provided on line 2!");
            }
        }

        @Override
        public String getShortDescription() {
            return "Sets block " + (this.above ? "above" : "below") + " IC block.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"id{:data}", "+oFORCE if should force setting the block"};
        }

        @Override
        public void addConfiguration(YAMLProcessor config, String path) {
            config.setComment("blacklist", "Stops the IC from placing the listed blocks.");
            this.blockBlacklist = BlockParser.getBlocks(config.getStringList("blacklist", (List)Lists.newArrayList((Object[])new String[]{BlockTypes.BEDROCK.id()})), true);
        }
    }
}

