/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.world.blocks;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.item.ItemType;
import java.util.Locale;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.inventory.ItemStack;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.util.BlockParser;

public abstract class SetBlock
extends AbstractSelfTriggeredIC {
    BlockStateHolder item;
    String force;

    public SetBlock(Server server, BukkitChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public void load() {
        this.force = this.getLine(3).toUpperCase(Locale.ENGLISH).trim();
        this.item = BlockParser.getBlock(this.getLine(2));
    }

    public void onTrigger() {
        Block body = this.getBackBlock();
        this.doSet(body, this.item, this.force.equals("FORCE"));
    }

    @Override
    public void trigger(ChipState chip) {
        chip.setOutput(0, chip.getInput(0));
        this.onTrigger();
    }

    @Override
    public void think(ChipState chip) {
        this.onTrigger();
    }

    protected abstract void doSet(Block var1, BlockStateHolder var2, boolean var3);

    public boolean takeFromChest(Block bl, ItemType item) {
        if (bl.getType() != Material.CHEST) {
            return false;
        }
        Material material = BukkitAdapter.adapt((ItemType)item);
        BlockState state = bl.getState();
        if (!(state instanceof Chest)) {
            return false;
        }
        Chest c = (Chest)state;
        ItemStack[] is = c.getInventory().getContents();
        for (int i = 0; i < is.length; ++i) {
            ItemStack stack = is[i];
            if (stack == null || stack.getAmount() <= 0 || stack.getType() != material) continue;
            if (stack.getAmount() == 1) {
                is[i] = new ItemStack(Material.AIR, 0);
            } else {
                stack.setAmount(stack.getAmount() - 1);
            }
            c.getInventory().setContents(is);
            return true;
        }
        return false;
    }
}

