/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.world.blocks;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.util.Locale;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractIC;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.mechanics.ic.RestrictedIC;
import org.enginehub.craftbook.util.BlockParser;
import org.enginehub.craftbook.util.RegexUtil;

public class MultipleSetBlock
extends AbstractIC {
    private int x;
    private int y;
    private int z;
    private BlockData onBlock;
    private BlockData offblock;
    private String[] dim;

    public MultipleSetBlock(Server server, BukkitChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public void load() {
        String line3 = this.getLine(2).replace("+", "").toUpperCase(Locale.ENGLISH);
        String line4 = this.getLine(3);
        this.getSign().setLine(2, (Component)Component.text((String)line3));
        this.getSign().update(false);
        String[] coords = RegexUtil.COLON_PATTERN.split(line3, 4);
        Block body = this.getBackBlock();
        this.x = body.getX();
        this.y = body.getY();
        this.z = body.getZ();
        if (coords.length < 4) {
            return;
        }
        String[] blocks = RegexUtil.MINUS_PATTERN.split(coords[3]);
        this.onBlock = BukkitAdapter.adapt((BlockStateHolder)BlockParser.getBlock(blocks[0]));
        this.offblock = blocks.length > 1 ? BukkitAdapter.adapt((BlockStateHolder)BlockParser.getBlock(blocks[1])) : Material.AIR.createBlockData();
        this.x += Integer.parseInt(coords[0]);
        this.y += Integer.parseInt(coords[1]);
        this.z += Integer.parseInt(coords[2]);
        this.dim = RegexUtil.COLON_PATTERN.split(line4);
    }

    @Override
    public String getTitle() {
        return "Multiple SetBlock";
    }

    @Override
    public String getSignTitle() {
        return "MULTI-SET BLOCK";
    }

    @Override
    public void trigger(ChipState chip) {
        BlockData setBlock = this.onBlock;
        chip.setOutput(0, chip.getInput(0));
        boolean inp = chip.getInput(0);
        if (!inp) {
            setBlock = this.offblock;
        }
        Block body = this.getBackBlock();
        if (this.dim.length == 3) {
            int dimX = Integer.parseInt(this.dim[0]);
            int dimY = Integer.parseInt(this.dim[1]);
            int dimZ = Integer.parseInt(this.dim[2]);
            for (int lx = 0; lx < dimX; ++lx) {
                for (int ly = 0; ly < dimY; ++ly) {
                    for (int lz = 0; lz < dimZ; ++lz) {
                        body.getWorld().getBlockAt(this.x + lx, this.y + ly, this.z + lz).setBlockData(setBlock, true);
                    }
                }
            }
        } else {
            body.getWorld().getBlockAt(this.x, this.y, this.z).setBlockData(setBlock, true);
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new MultipleSetBlock(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Sets multiple blocks.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"x:y:z:onid:ondata-offid:offdata", "width:height:depth"};
        }
    }
}

