/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.world.blocks;

import com.sk89q.worldedit.math.BlockVector3;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.mechanics.ic.RestrictedIC;
import org.enginehub.craftbook.util.ICUtil;

public class LiquidFlood
extends AbstractSelfTriggeredIC {
    BlockVector3 radius;
    String liquid;
    Location centre;

    public LiquidFlood(Server server, BukkitChangedSign block, ICFactory factory) {
        super(server, block, factory);
    }

    @Override
    public String getTitle() {
        return "Liquid Flooder";
    }

    @Override
    public String getSignTitle() {
        return "LIQUID FLOOD";
    }

    @Override
    public void load() {
        this.centre = ICUtil.parseBlockLocation(this.getSign()).getLocation();
        this.radius = ICUtil.parseRadius(this.getSign()).toBlockPoint();
        this.liquid = this.getLine(2).equalsIgnoreCase("lava") ? "lava" : "water";
    }

    public void doStuff(ChipState chip) {
        block7: {
            block6: {
                if (!chip.getInput(0)) break block6;
                for (int x = -this.radius.x() + 1; x < this.radius.x(); ++x) {
                    for (int y = -this.radius.y() + 1; y < this.radius.y(); ++y) {
                        for (int z = -this.radius.z() + 1; z < this.radius.z(); ++z) {
                            int rx = this.centre.getBlockX() - x;
                            int ry = this.centre.getBlockY() - y;
                            int rz = this.centre.getBlockZ() - z;
                            Block b = this.getSign().getBlock().getWorld().getBlockAt(rx, ry, rz);
                            if (b.getType() != Material.AIR && b.getType() != (this.liquid.equalsIgnoreCase("water") ? Material.WATER : Material.LAVA)) continue;
                            b.setType(this.liquid.equalsIgnoreCase("water") ? Material.WATER : Material.LAVA);
                        }
                    }
                }
                break block7;
            }
            if (chip.getInput(0)) break block7;
            for (int x = -this.radius.x() + 1; x < this.radius.x(); ++x) {
                for (int y = -this.radius.y() + 1; y < this.radius.y(); ++y) {
                    for (int z = -this.radius.z() + 1; z < this.radius.z(); ++z) {
                        int rx = this.centre.getBlockX() - x;
                        int ry = this.centre.getBlockY() - y;
                        int rz = this.centre.getBlockZ() - z;
                        Block b = this.getSign().getBlock().getWorld().getBlockAt(rx, ry, rz);
                        if (b.getType() != (this.liquid.equalsIgnoreCase("water") ? Material.WATER : Material.LAVA)) continue;
                        b.setType(Material.AIR);
                    }
                }
            }
        }
    }

    @Override
    public void trigger(ChipState chip) {
        this.doStuff(chip);
    }

    @Override
    public void think(ChipState state) {
        this.doStuff(state);
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new LiquidFlood(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Floods an area with a liquid.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"+owater/lava", "+oradius=x:y:z offset"};
        }
    }
}

