/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.world.blocks;

import java.util.HashMap;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Farmland;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.mechanics.ic.ICVerificationException;
import org.enginehub.craftbook.util.InventoryUtil;
import org.enginehub.craftbook.util.SearchArea;

public class Irrigator
extends AbstractSelfTriggeredIC {
    private SearchArea area;

    public Irrigator(Server server, BukkitChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public void load() {
        this.area = SearchArea.createArea(this.getLocation().getBlock(), this.getLine(2));
    }

    @Override
    public String getTitle() {
        return "Irrigator";
    }

    @Override
    public String getSignTitle() {
        return "IRRIGATOR";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.irrigate());
        }
    }

    @Override
    public void think(ChipState chip) {
        if (chip.getInput(0)) {
            return;
        }
        for (int i = 0; i < 10; ++i) {
            chip.setOutput(0, this.irrigate());
        }
    }

    public boolean irrigate() {
        Farmland farmland;
        Block b = this.area.getRandomBlockInArea();
        if (b == null) {
            return false;
        }
        if (b.getType() == Material.FARMLAND && (farmland = (Farmland)b.getBlockData()).getMoisture() < 1 && this.consumeWater()) {
            farmland.setMoisture(farmland.getMaximumMoisture());
            b.setBlockData((BlockData)farmland);
            return true;
        }
        return false;
    }

    public boolean consumeWater() {
        Block chest = this.getBackBlock().getRelative(0, 1, 0);
        if (InventoryUtil.doesBlockHaveInventory(chest)) {
            InventoryHolder c = (InventoryHolder)chest.getState();
            HashMap over = c.getInventory().removeItem(new ItemStack[]{new ItemStack(Material.WATER_BUCKET, 1)});
            if (over.isEmpty()) {
                c.getInventory().addItem(new ItemStack[]{new ItemStack(Material.BUCKET, 1)});
                return true;
            }
        } else if (chest.getType() == Material.WATER) {
            chest.setType(Material.AIR);
            return true;
        }
        return false;
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new Irrigator(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Irrigates nearby farmland using water in above chest.";
        }

        @Override
        public String[] getLongDescription() {
            return new String[]{"The '''MC1238''' irrigates soil in the selected search area with water found in the chest above the IC.", "This IC is part of the Farming IC family, and can be used to make a fully automated farm."};
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"+oSearchArea", null};
        }

        @Override
        public void verify(BukkitChangedSign sign) throws ICVerificationException {
            if (!SearchArea.isValidArea(sign.getBlock(), PlainTextComponentSerializer.plainText().serialize(sign.getLine(2)))) {
                throw new ICVerificationException("Invalid SearchArea on 3rd line!");
            }
        }
    }
}

