/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.world.blocks;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.util.Locale;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractIC;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.mechanics.ic.ICVerificationException;
import org.enginehub.craftbook.mechanics.ic.RestrictedIC;
import org.enginehub.craftbook.util.BlockParser;
import org.enginehub.craftbook.util.RegexUtil;

public class FlexibleSetBlock
extends AbstractIC {
    private int x;
    private int y;
    private int z;
    private Block body;
    private boolean hold;
    BlockData block;

    public FlexibleSetBlock(Server server, BukkitChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public void load() {
        int dist;
        String line3 = this.getLine(2).toUpperCase(Locale.ENGLISH);
        String line4 = this.getLine(3);
        String[] params = RegexUtil.COLON_PATTERN.split(line3, 2);
        if (params.length < 2) {
            return;
        }
        if (params[0].length() < 2) {
            return;
        }
        String axis = params[0].substring(0, 1);
        if (!(axis.equals("X") || axis.equals("Y") || axis.equals("Z"))) {
            return;
        }
        String op = params[0].substring(1, 2);
        int distStart = 2;
        if (!op.equals("+") && !op.equals("-")) {
            op = "+";
            distStart = 1;
        }
        String sdist = params[0].substring(distStart);
        try {
            dist = Integer.parseInt(sdist);
        }
        catch (Exception e) {
            return;
        }
        if (op.equals("-")) {
            dist = -dist;
        }
        try {
            this.block = BukkitAdapter.adapt((BlockStateHolder)BlockParser.getBlock(params[1]));
        }
        catch (Exception e) {
            return;
        }
        this.hold = line4.toUpperCase(Locale.ENGLISH).contains("H");
        this.body = this.getBackBlock();
        this.x = this.body.getX();
        this.y = this.body.getY();
        this.z = this.body.getZ();
        switch (axis) {
            case "X": {
                this.x += dist;
                break;
            }
            case "Y": {
                this.y += dist;
                break;
            }
            default: {
                this.z += dist;
            }
        }
    }

    @Override
    public String getTitle() {
        return "Flexible Set";
    }

    @Override
    public String getSignTitle() {
        return "FLEX SET";
    }

    @Override
    public void trigger(ChipState chip) {
        chip.setOutput(0, chip.getInput(0));
        boolean inp = chip.getInput(0);
        if (this.body == null) {
            return;
        }
        if (inp) {
            this.body.getWorld().getBlockAt(this.x, this.y, this.z).setBlockData(this.block, true);
        } else if (this.hold) {
            this.body.getWorld().getBlockAt(this.x, this.y, this.z).setType(Material.AIR);
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new FlexibleSetBlock(this.getServer(), sign, this);
        }

        @Override
        public void verify(BukkitChangedSign sign) throws ICVerificationException {
            String line3 = PlainTextComponentSerializer.plainText().serialize(sign.getLine(2)).toUpperCase(Locale.ENGLISH);
            String[] params = RegexUtil.COLON_PATTERN.split(line3, 2);
            if (params.length < 2) {
                throw new ICVerificationException("Not enough parameters on second line!");
            }
            if (params[0].length() < 2) {
                throw new ICVerificationException("Invalid first parameter!");
            }
            String axis = params[0].substring(0, 1);
            if (!(axis.equals("X") || axis.equals("Y") || axis.equals("Z"))) {
                throw new ICVerificationException("Invalid axis!");
            }
            String op = params[0].substring(1, 2);
            int distStart = 2;
            if (!op.equals("+") && !op.equals("-")) {
                op = "+";
                distStart = 1;
            }
            String sdist = params[0].substring(distStart);
            try {
                Integer.parseInt(sdist);
            }
            catch (Exception e) {
                throw new ICVerificationException("Invalid distance!");
            }
            try {
                Preconditions.checkNotNull((Object)BlockParser.getBlock(params[1]));
            }
            catch (Exception e) {
                throw new ICVerificationException("Invalid block!");
            }
        }

        @Override
        public String getShortDescription() {
            return "Sets a block at a specified distance on a specific axis. Can also hold a block at a place until low power.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"axis{+/-}distance:blockTypeId{:blockData}", "H to clear on low."};
        }
    }
}

