/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.world.blocks;

import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.math.BlockVector3;
import java.util.concurrent.ThreadLocalRandom;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.ConfigurableIC;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.mechanics.ic.ICVerificationException;
import org.enginehub.craftbook.mechanics.ic.RestrictedIC;
import org.enginehub.craftbook.util.BlockUtil;
import org.enginehub.craftbook.util.ICUtil;
import org.enginehub.craftbook.util.InventoryUtil;

public class Driller
extends AbstractSelfTriggeredIC {
    private int signDrillSize;
    private int signMaxDepth;

    public Driller(Server server, BukkitChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public void think(ChipState chip) {
        if (!chip.getInput(0)) {
            chip.setOutput(0, this.drill());
        }
    }

    @Override
    public String getTitle() {
        return "Driller";
    }

    @Override
    public String getSignTitle() {
        return "DRILLER";
    }

    @Override
    public void load() {
        super.load();
        this.signDrillSize = ((Factory)this.getFactory()).drillSize;
        if (!this.getLine(2).isEmpty()) {
            this.signDrillSize = Math.min(this.signDrillSize, Integer.parseInt(this.getLine(2)));
        }
        this.signMaxDepth = ((Factory)this.getFactory()).maxDrillDepth;
        if (!this.getLine(3).isEmpty()) {
            this.signMaxDepth = Math.min(this.signMaxDepth, Integer.parseInt(this.getLine(3)));
        }
    }

    public boolean drill() {
        InventoryHolder holder;
        if (ThreadLocalRandom.current().nextInt(100) < 60) {
            return false;
        }
        Block center = this.getBackBlock().getRelative(0, -1, 0);
        ItemStack tool = null;
        if (InventoryUtil.doesBlockHaveInventory(center.getRelative(0, 2, 0)) && (holder = (InventoryHolder)center.getRelative(0, 2, 0).getState()).getInventory().getItem(0) != null) {
            tool = holder.getInventory().getItem(0);
        }
        int random = ThreadLocalRandom.current().nextInt(this.signDrillSize * this.signDrillSize);
        int x = random / this.signDrillSize;
        int y = random % this.signDrillSize;
        return this.drillLine(tool, center.getRelative(this.signDrillSize / 2 - x, 0, this.signDrillSize / 2 - y));
    }

    public boolean drillLine(ItemStack tool, Block blockToBreak) {
        Material brokenType = Material.AIR;
        int depth = 0;
        while (brokenType == Material.AIR) {
            if (blockToBreak.getLocation().getBlockY() == 0 || depth > this.signMaxDepth) {
                return false;
            }
            blockToBreak = blockToBreak.getRelative(0, -1, 0);
            ++depth;
            brokenType = blockToBreak.getType();
            if (brokenType != Material.BEDROCK) continue;
            return false;
        }
        ICUtil.collectItem(this, BlockVector3.at((int)0, (int)1, (int)0), BlockUtil.getBlockDrops(blockToBreak, tool));
        brokenType = blockToBreak.getType();
        blockToBreak.setType(Material.AIR);
        return brokenType != Material.LAVA && brokenType != Material.WATER;
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.drill());
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC,
    ConfigurableIC {
        int drillSize;
        int maxDrillDepth;

        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new Driller(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Breaks a line of blocks from the IC block.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"+odrill size", "+omax depth"};
        }

        @Override
        public void addConfiguration(YAMLProcessor config, String path) {
            this.drillSize = config.getInt("drill-size", 3);
            this.maxDrillDepth = config.getInt("max-drill-depth", 256);
        }

        @Override
        public void verify(BukkitChangedSign sign) throws ICVerificationException {
            try {
                String line3;
                String line2 = PlainTextComponentSerializer.plainText().serialize(sign.getLine(2));
                if (!line2.isEmpty()) {
                    sign.setLine(2, (Component)Component.text((int)Math.min(this.drillSize, Integer.parseInt(line2))));
                }
                if (!(line3 = PlainTextComponentSerializer.plainText().serialize(sign.getLine(3))).isEmpty()) {
                    sign.setLine(3, (Component)Component.text((int)Math.min(this.maxDrillDepth, Integer.parseInt(line3))));
                }
            }
            catch (Exception e) {
                throw new ICVerificationException("Failed to parse numbers.");
            }
        }
    }
}

