/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.world.blocks;

import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.entity.FallingBlock;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractIC;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.mechanics.ic.ICVerificationException;
import org.enginehub.craftbook.mechanics.ic.RestrictedIC;
import org.enginehub.craftbook.util.ItemSyntax;
import org.enginehub.craftbook.util.ItemUtil;
import org.enginehub.craftbook.util.RegexUtil;

public class BlockLauncher
extends AbstractIC {
    Vector velocity;
    ItemStack block;

    public BlockLauncher(Server server, BukkitChangedSign block, ICFactory factory) {
        super(server, block, factory);
    }

    @Override
    public String getTitle() {
        return "Block Launcher";
    }

    @Override
    public String getSignTitle() {
        return "BLOCK LAUNCH";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            this.launch();
        }
    }

    @Override
    public void load() {
        this.block = ItemUtil.makeItemValid(ItemSyntax.getItem(this.getLine(2)));
        if (this.getLine(2).isEmpty() || this.block == null) {
            this.block = new ItemStack(Material.SAND, 1);
        }
        if (this.getLine(3).isEmpty()) {
            this.velocity = new Vector(0.0, 0.5, 0.0);
        } else {
            String[] split2 = RegexUtil.COLON_PATTERN.split(this.getLine(3));
            this.velocity = new Vector(Double.parseDouble(split2[0]), Double.parseDouble(split2[1]), Double.parseDouble(split2[2]));
        }
    }

    public void launch() {
        int timeout;
        Block above = this.getBackBlock().getRelative(0, 1, 0);
        for (timeout = 12; above.getType() != Material.AIR || timeout < 0 || above.getLocation().getY() >= 255.0; --timeout) {
            above = above.getRelative(0, 1, 0);
        }
        if (this.velocity.getY() < 0.0) {
            above = this.getBackBlock().getRelative(0, -1, 0);
            for (timeout = 12; above.getType() != Material.AIR || timeout < 0 || above.getLocation().getY() <= (double)(above.getWorld().getMinHeight() + 1); --timeout) {
                above = above.getRelative(0, -1, 0);
            }
        }
        double y = (double)above.getY() - 0.99;
        if (!new Location(this.getSign().getBlock().getWorld(), (double)above.getX() + 0.5, y, (double)above.getZ() + 0.5).getChunk().isLoaded()) {
            return;
        }
        FallingBlock block = this.getSign().getBlock().getWorld().spawnFallingBlock(new Location(this.getSign().getBlock().getWorld(), (double)above.getX() + 0.5, y, (double)above.getZ() + 0.5), this.block.getType(), this.block.getData().getData());
        block.setVelocity(this.velocity);
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new BlockLauncher(this.getServer(), sign, this);
        }

        @Override
        public void verify(BukkitChangedSign sign) throws ICVerificationException {
            String line3 = PlainTextComponentSerializer.plainText().serialize(sign.getLine(3));
            if (!line3.isEmpty()) {
                try {
                    String[] split2 = RegexUtil.COLON_PATTERN.split(line3);
                    new Vector(Double.parseDouble(split2[0]), Double.parseDouble(split2[1]), Double.parseDouble(split2[2]));
                }
                catch (Exception ignored) {
                    throw new ICVerificationException("Velocity must be in x:y:z format!");
                }
            }
        }

        @Override
        public String getShortDescription() {
            return "Launches set block with set velocity.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"id{:data}", "+ovelocity x:y:z"};
        }
    }
}

