/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.world.blocks;

import com.google.common.collect.Lists;
import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.blocks.Blocks;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.List;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.ConfigurableIC;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.mechanics.ic.ICVerificationException;
import org.enginehub.craftbook.util.BlockParser;
import org.enginehub.craftbook.util.BlockUtil;
import org.enginehub.craftbook.util.ICUtil;

public class BlockBreaker
extends AbstractSelfTriggeredIC {
    private Block broken;
    private BaseBlock item;

    public BlockBreaker(Server server, BukkitChangedSign block, ICFactory factory) {
        super(server, block, factory);
    }

    @Override
    public String getTitle() {
        return "Block Breaker";
    }

    @Override
    public String getSignTitle() {
        return "BLOCK BREAK";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.breakBlock());
        }
    }

    @Override
    public void think(ChipState state) {
        state.setOutput(0, this.breakBlock());
    }

    @Override
    public void load() {
        this.item = BlockParser.getBlock(this.getLine(2), true);
    }

    public boolean breakBlock() {
        boolean above = ((Factory)this.getFactory()).above;
        if (this.broken == null) {
            Block bl = this.getBackBlock();
            this.broken = above ? bl.getRelative(0, 1, 0) : bl.getRelative(0, -1, 0);
        }
        BlockData brokenData = this.broken.getBlockData();
        if (this.broken.getType() == Material.AIR || this.broken.getType() == Material.MOVING_PISTON || Blocks.containsFuzzy(((Factory)this.getFactory()).blockBlacklist, (BlockStateHolder)BukkitAdapter.adapt((BlockData)brokenData))) {
            return false;
        }
        if (this.item == null || this.item.equalsFuzzy((BlockStateHolder)BukkitAdapter.adapt((BlockData)brokenData))) {
            ICUtil.collectItem(this, above ? BlockVector3.at((int)0, (int)-1, (int)0) : BlockVector3.at((int)0, (int)1, (int)0), BlockUtil.getBlockDrops(this.broken, null));
            this.broken.setType(Material.AIR);
        }
        return true;
    }

    public static class Factory
    extends AbstractICFactory
    implements ConfigurableIC {
        boolean above;
        List<BaseBlock> blockBlacklist;

        public Factory(Server server, boolean above) {
            super(server);
            this.above = above;
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new BlockBreaker(this.getServer(), sign, this);
        }

        @Override
        public void verify(BukkitChangedSign sign) throws ICVerificationException {
            if (!PlainTextComponentSerializer.plainText().serialize(sign.getLine(2)).trim().isEmpty()) {
                BaseBlock item = BlockParser.getBlock(PlainTextComponentSerializer.plainText().serialize(sign.getLine(2)), true);
                if (item == null) {
                    throw new ICVerificationException("An invalid block was provided on line 2!");
                }
                if (Blocks.containsFuzzy(this.blockBlacklist, (BlockStateHolder)item)) {
                    throw new ICVerificationException("A blacklisted block was provided on line 2!");
                }
            }
        }

        @Override
        public String getShortDescription() {
            return "Breaks blocks " + (this.above ? "above" : "below") + " block sign is on.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"+oBlock ID:Data", null};
        }

        @Override
        public void addConfiguration(YAMLProcessor config, String path) {
            config.setComment("blacklist", "Stops the IC from breaking the listed blocks.");
            this.blockBlacklist = BlockParser.getBlocks(config.getStringList("blacklist", (List)Lists.newArrayList((Object[])new String[]{BlockTypes.BEDROCK.id()})), true);
        }
    }
}

