/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.variables;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.extension.platform.Actor;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Server;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractIC;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.mechanics.ic.ICVerificationException;
import org.enginehub.craftbook.mechanics.variables.VariableKey;
import org.enginehub.craftbook.mechanics.variables.VariableManager;
import org.enginehub.craftbook.mechanics.variables.exception.VariableException;

public class NumericModifier
extends AbstractIC {
    MathFunction function;
    String variable;
    double amount;

    public NumericModifier(Server server, BukkitChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public String getTitle() {
        return "Variable Modifier";
    }

    @Override
    public String getSignTitle() {
        return "VAR MODIFIER";
    }

    @Override
    public void load() {
        try {
            this.variable = this.getLine(2);
            this.function = MathFunction.parseFunction(this.getLine(3).split(":")[0]);
            this.amount = Double.parseDouble(this.getLine(3).split(":")[1]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            if (this.function == null) {
                chip.setOutput(0, false);
                return;
            }
            try {
                VariableKey variableKey = VariableKey.fromString(this.variable, null);
                double currentValue = Double.parseDouble(VariableManager.instance.getVariable(variableKey));
                currentValue = this.function.parseNumber(currentValue, this.amount);
                String val = String.valueOf(currentValue);
                if (val.endsWith(".0")) {
                    val = val.replace(".0", "");
                }
                VariableManager.instance.setVariable(variableKey, val);
                chip.setOutput(0, true);
                return;
            }
            catch (NumberFormatException | VariableException exception) {
                // empty catch block
            }
        }
        chip.setOutput(0, false);
    }

    public static enum MathFunction {
        ADD("+"),
        SUBTRACT("-"),
        MULTIPLY("*", "x"),
        DIVIDE("/"),
        MOD("%");

        String[] mini;

        private MathFunction(String ... mini) {
            this.mini = mini;
        }

        public static MathFunction parseFunction(String text) {
            for (MathFunction func : MathFunction.values()) {
                if (func.name().equalsIgnoreCase(text)) {
                    return func;
                }
                for (String min : func.mini) {
                    if (!min.equalsIgnoreCase(text)) continue;
                    return func;
                }
            }
            return null;
        }

        public double parseNumber(double initial, double amount) {
            switch (this.ordinal()) {
                case 0: {
                    initial += amount;
                    break;
                }
                case 3: {
                    if (amount == 0.0) {
                        return initial;
                    }
                    initial /= amount;
                    break;
                }
                case 2: {
                    initial *= amount;
                    break;
                }
                case 1: {
                    initial -= amount;
                    break;
                }
                case 4: {
                    initial %= amount;
                    break;
                }
            }
            return initial;
        }
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new NumericModifier(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Modifies a variable using the specified function.";
        }

        @Override
        public String[] getLongDescription() {
            return new String[]{"The '''VAR100''' IC allows for the modification of numerical variables using common binary operations (Known an Functions).", "", "== Functions ==", "{| class=\"wiki-table sortable\"", "! Name", "! Symbol", "! Function", "|-", "| Add || + || Adds the inputted value to the variable.", "|-", "| Subtract || - || Subtracts the inputted value from the variable.", "|-", "| Multiply || * OR x || Multiplies the inputted value by the variable.", "|-", "| Divide || / || Divides the inputted value by the variable.", "|-", "| Mod || % || Performs modulo by the inputted value on the variable.", "|}"};
        }

        @Override
        public String[] getPinDescription(ChipState state) {
            return new String[]{"Trigger IC", "High on success"};
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"Variable Name", "Function:Amount"};
        }

        @Override
        public void checkPlayer(BukkitChangedSign sign, CraftBookPlayer player) throws ICVerificationException {
            try {
                String line2 = PlainTextComponentSerializer.plainText().serialize(sign.getLine(2));
                VariableKey variableKey = VariableKey.fromString(line2, (Actor)player);
                if (variableKey != null && !variableKey.hasPermission((Actor)player, "use")) {
                    throw new ICVerificationException("You do not have permissions to use " + String.valueOf(variableKey) + "!");
                }
            }
            catch (VariableException e) {
                throw new ICVerificationException(e.getMessage(), (Throwable)e);
            }
        }

        @Override
        public void verify(BukkitChangedSign sign) throws ICVerificationException {
            try {
                String line2 = PlainTextComponentSerializer.plainText().serialize(sign.getLine(2));
                VariableKey variableKey = VariableKey.fromString(line2, null);
                if (variableKey == null || !VariableManager.instance.hasVariable(variableKey)) {
                    throw new ICVerificationException("Unknown Variable!");
                }
                String line3 = PlainTextComponentSerializer.plainText().serialize(sign.getLine(3));
                Preconditions.checkNotNull((Object)((Object)MathFunction.parseFunction(line3.split(":")[0])));
                Double.parseDouble(line3.split(":")[1]);
            }
            catch (NumberFormatException e) {
                throw new ICVerificationException("Amount must be a number!");
            }
            catch (IllegalArgumentException e) {
                throw new ICVerificationException("Invalid Function!");
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new ICVerificationException("Both Function and Amount must be entered, seperated by a colon (:)!");
            }
            catch (VariableException e) {
                throw new ICVerificationException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

