/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.variables;

import com.sk89q.worldedit.extension.platform.Actor;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Server;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractIC;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.mechanics.ic.ICVerificationException;
import org.enginehub.craftbook.mechanics.variables.VariableKey;
import org.enginehub.craftbook.mechanics.variables.VariableManager;
import org.enginehub.craftbook.mechanics.variables.exception.VariableException;
import org.enginehub.craftbook.util.InventoryUtil;
import org.enginehub.craftbook.util.ItemSyntax;
import org.enginehub.craftbook.util.ItemUtil;

public class ItemCounter
extends AbstractIC {
    String variable;
    ItemStack item;

    public ItemCounter(Server server, BukkitChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public String getTitle() {
        return "Item Counter";
    }

    @Override
    public String getSignTitle() {
        return "ITEM COUNTER";
    }

    @Override
    public void load() {
        this.variable = this.getLine(2);
        this.item = ItemSyntax.getItem(this.getLine(3));
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            int amount = 0;
            if (InventoryUtil.doesBlockHaveInventory(this.getBackBlock().getRelative(0, 1, 0))) {
                InventoryHolder chest = (InventoryHolder)this.getBackBlock().getRelative(0, 1, 0).getState();
                for (ItemStack stack : chest.getInventory().getContents()) {
                    if (!ItemUtil.isStackValid(stack) || this.item != null && !ItemUtil.areItemsIdentical(stack, this.item)) continue;
                    amount += stack.getAmount();
                }
            }
            chip.setOutput(0, amount > 0);
            try {
                VariableKey variableKey = VariableKey.fromString(this.variable, null);
                double existing = Double.parseDouble(VariableManager.instance.getVariable(variableKey));
                String val = String.valueOf(existing + (double)amount);
                if (val.endsWith(".0")) {
                    val = val.replace(".0", "");
                }
                VariableManager.instance.setVariable(variableKey, val);
            }
            catch (VariableException e) {
                CraftBook.LOGGER.error("Failed to tick IC at " + String.valueOf(this.getBackBlock().getLocation()), (Throwable)e);
            }
        }
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new ItemCounter(this.getServer(), sign, this);
        }

        @Override
        public String[] getLongDescription() {
            return new String[]{"The '''VAR200''' IC searches a chest and counts the amounts of all items that match the last line of the sign. ", "The counted amount is then added to the variable listed on the 3rd line."};
        }

        @Override
        public String getShortDescription() {
            return "Adds to a variable the amount of items of a type counted.";
        }

        @Override
        public String[] getPinDescription(ChipState state) {
            return new String[]{"Trigger IC", "High if found item"};
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"Variable Name", "ItemSyntax"};
        }

        @Override
        public void checkPlayer(BukkitChangedSign sign, CraftBookPlayer player) throws ICVerificationException {
            try {
                VariableKey variableKey = VariableKey.fromString(PlainTextComponentSerializer.plainText().serialize(sign.getLine(2)), (Actor)player);
                if (variableKey != null && !variableKey.hasPermission((Actor)player, "use")) {
                    throw new ICVerificationException("You do not have permissions to use " + variableKey.toString());
                }
            }
            catch (VariableException e) {
                throw new ICVerificationException("Can't use variable", (Throwable)e);
            }
        }

        @Override
        public void verify(BukkitChangedSign sign) throws ICVerificationException {
            try {
                VariableKey variableKey = VariableKey.fromString(PlainTextComponentSerializer.plainText().serialize(sign.getLine(2)), null);
                if (variableKey == null || !VariableManager.instance.hasVariable(variableKey)) {
                    throw new ICVerificationException("Unknown Variable!");
                }
            }
            catch (VariableException e) {
                throw new ICVerificationException("Can't use variable", (Throwable)e);
            }
        }
    }
}

