/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.variables;

import com.sk89q.worldedit.extension.platform.Actor;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Server;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.mechanics.ic.ICVerificationException;
import org.enginehub.craftbook.mechanics.variables.VariableKey;
import org.enginehub.craftbook.mechanics.variables.VariableManager;
import org.enginehub.craftbook.mechanics.variables.exception.VariableException;

public class IsAtLeast
extends AbstractSelfTriggeredIC {
    String variable;
    double amount;

    public IsAtLeast(Server server, BukkitChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public String getTitle() {
        return "Is At Least";
    }

    @Override
    public String getSignTitle() {
        return "IS AT LEAST";
    }

    @Override
    public void load() {
        try {
            this.variable = this.getLine(2);
            this.amount = Double.parseDouble(this.getLine(3));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.isAtLeast());
        }
    }

    @Override
    public void think(ChipState chip) {
        chip.setOutput(0, this.isAtLeast());
    }

    public boolean isAtLeast() {
        try {
            VariableKey variableKey = VariableKey.fromString(this.variable, null);
            double existing = Double.parseDouble(VariableManager.instance.getVariable(variableKey));
            return existing >= this.amount;
        }
        catch (VariableException e) {
            CraftBook.LOGGER.error("Failed to tick IC at " + String.valueOf(this.getBackBlock().getLocation()), (Throwable)e);
            return false;
        }
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new IsAtLeast(this.getServer(), sign, this);
        }

        @Override
        public String[] getLongDescription() {
            return new String[]{"The '''VAR170''' IC checks a numerical variable against an amount listed on the sign.", "If the variable on the sign has a value greater than that listed on the sign, the IC will output high."};
        }

        @Override
        public String getShortDescription() {
            return "Checks if a variable is at least...";
        }

        @Override
        public String[] getPinDescription(ChipState state) {
            return new String[]{"Trigger IC", "High if variable is at least"};
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"Variable Name", "Amount"};
        }

        @Override
        public void checkPlayer(BukkitChangedSign sign, CraftBookPlayer player) throws ICVerificationException {
            try {
                VariableKey variableKey = VariableKey.fromString(PlainTextComponentSerializer.plainText().serialize(sign.getLine(2)), (Actor)player);
                if (variableKey != null && !variableKey.hasPermission((Actor)player, "use")) {
                    throw new ICVerificationException("You do not have permissions to use " + variableKey.toString());
                }
            }
            catch (VariableException e) {
                throw new ICVerificationException("Can't use this variable", (Throwable)e);
            }
        }

        @Override
        public void verify(BukkitChangedSign sign) throws ICVerificationException {
            try {
                VariableKey variableKey = VariableKey.fromString(PlainTextComponentSerializer.plainText().serialize(sign.getLine(2)), null);
                if (variableKey == null || !VariableManager.instance.hasVariable(variableKey)) {
                    throw new ICVerificationException("Unknown Variable!");
                }
                Double.parseDouble(PlainTextComponentSerializer.plainText().serialize(sign.getLine(3)));
            }
            catch (NumberFormatException e) {
                throw new ICVerificationException("Amount must be a number!");
            }
            catch (VariableException e) {
                throw new ICVerificationException("Can't use this variable", (Throwable)e);
            }
        }
    }
}

