/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.logic;

import org.bukkit.Server;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.mechanics.ic.gates.logic.SimpleTwoInputLogicGate;

public class XorGate
extends SimpleTwoInputLogicGate {
    public XorGate(Server server, BukkitChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public String getTitle() {
        return "XOR Gate";
    }

    @Override
    public String getSignTitle() {
        return "XOR";
    }

    @Override
    protected boolean getResult(boolean a, boolean b) {
        return a != b;
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public String[] getPinDescription(ChipState state) {
            return new String[]{"Input", "Input", "Input", "High if two inputs are not equal"};
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new XorGate(this.getServer(), sign, this);
        }
    }
}

