/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.logic;

import org.bukkit.Server;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractIC;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;

public class ToggleFlipFlop
extends AbstractIC {
    protected final boolean risingEdge;

    public ToggleFlipFlop(Server server, BukkitChangedSign sign, boolean risingEdge, ICFactory factory) {
        super(server, sign, factory);
        this.risingEdge = risingEdge;
    }

    @Override
    public String getTitle() {
        return "Toggle Flip Flop";
    }

    @Override
    public String getSignTitle() {
        return "TOGGLE";
    }

    @Override
    public void trigger(ChipState chip) {
        if (this.risingEdge == chip.getInput(0)) {
            chip.setOutput(0, !chip.getOutput(0));
        }
    }

    public static class Factory
    extends AbstractICFactory {
        protected final boolean risingEdge;

        public Factory(Server server, boolean risingEdge) {
            super(server);
            this.risingEdge = risingEdge;
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new ToggleFlipFlop(this.getServer(), sign, this.risingEdge, this);
        }

        @Override
        public String[] getLongDescription() {
            return new String[]{"The '''" + (this.risingEdge ? "MC1017" : "MC1018") + "''' is a toggle flip flop that toggles its output state between low and high whenever the input (the \"clock\") changes from " + (this.risingEdge ? "low to high." : "high to low"), "", "Equivalent [[../Perlstone/]] script: <code>" + (this.risingEdge ? "Lp1AdSp1.0100[Lp0!dSp0r]Lp0r" : "Lp1AdSp1.0010[Lp0!dSp0r]Lp0r") + "</code>", "", "== Uses ==", "* Connect two buttons to this IC to have the buttons toggle a door when used."};
        }

        @Override
        public String[] getPinDescription(ChipState state) {
            return new String[]{"Trigger IC on " + (this.risingEdge ? "high" : "low"), "Output"};
        }

        @Override
        public String getShortDescription() {
            return "Toggles output on " + (this.risingEdge ? "high." : "low.");
        }
    }
}

