/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.logic;

import org.bukkit.Server;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractIC;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;

public class RsNorFlipFlop
extends AbstractIC {
    public RsNorFlipFlop(Server server, BukkitChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public String getTitle() {
        return "RS-NOR flip-flop";
    }

    @Override
    public String getSignTitle() {
        return "RS-NOR";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(1) || chip.getInput(2)) {
            chip.setOutput(0, false);
            return;
        }
        if (chip.getInput(0)) {
            chip.setOutput(0, true);
        }
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public String[] getPinDescription(ChipState state) {
            return new String[]{"Set Output 0 to High", "Reset Output 0 to Low", "Reset Output 0 to Low", "Output"};
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new RsNorFlipFlop(this.getServer(), sign, this);
        }
    }
}

