/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.logic;

import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Server;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.util.RegexUtil;

public class RangedOutput
extends AbstractSelfTriggeredIC {
    int min;
    int max;
    int ticks = 0;
    int maxTicks = 0;
    boolean hasStarted = false;
    int amountDone = 0;
    int maxAmount = 0;

    public RangedOutput(Server server, BukkitChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public String getTitle() {
        return "Ranged Output";
    }

    @Override
    public String getSignTitle() {
        return "RANGE OUTPUT";
    }

    @Override
    public boolean isAlwaysST() {
        return true;
    }

    @Override
    public void think(ChipState chip) {
        chip.setOutput(0, this.shouldOutput(chip));
    }

    @Override
    public void load() {
        String[] minmax = RegexUtil.MINUS_PATTERN.split(this.getLine(2));
        this.min = Integer.parseInt(minmax[0]);
        this.max = Integer.parseInt(minmax[1]);
        this.maxTicks = !this.getLine(3).isEmpty() ? Integer.parseInt(this.getLine(3)) : 10;
    }

    protected boolean shouldOutput(ChipState chip) {
        if (chip.getInput(0)) {
            this.maxAmount = this.min + ThreadLocalRandom.current().nextInt(this.max - this.min + 1);
            this.amountDone = 0;
            this.ticks = 0;
            this.hasStarted = true;
            return false;
        }
        if (this.hasStarted) {
            if (this.ticks >= this.maxTicks) {
                ++this.amountDone;
                if (this.amountDone >= this.maxAmount) {
                    this.hasStarted = false;
                    this.amountDone = 0;
                    this.ticks = 0;
                    this.maxAmount = 0;
                }
                return true;
            }
            ++this.ticks;
            return false;
        }
        return false;
    }

    @Override
    public void trigger(ChipState chip) {
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new RangedOutput(this.getServer(), sign, this);
        }
    }
}

