/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.logic;

import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Server;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.util.RegexUtil;

public class RandomBit
extends AbstractSelfTriggeredIC {
    int maxOn;
    int minOn;

    public RandomBit(Server server, BukkitChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public String getTitle() {
        return "Random Bit";
    }

    @Override
    public String getSignTitle() {
        return "RANDOM BIT";
    }

    @Override
    public void load() {
        try {
            if (this.getLine(2).contains(":")) {
                String[] parts = RegexUtil.COLON_PATTERN.split(this.getLine(2));
                this.maxOn = Integer.parseInt(parts[1]);
                this.minOn = Integer.parseInt(parts[0]);
            } else {
                this.maxOn = Integer.parseInt(this.getLine(2));
                this.minOn = 0;
            }
        }
        catch (Exception e) {
            this.maxOn = -1;
            this.minOn = 0;
        }
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            this.randomize(chip);
        }
    }

    @Override
    public void think(ChipState chip) {
        if (chip.getInput(0)) {
            this.randomize(chip);
        }
    }

    public void randomize(ChipState chip) {
        int on = 0;
        int outputs = 0;
        for (int i = 0; i < chip.getInputCount(); i = (int)((short)(i + 1))) {
            if (!chip.isValid(i)) continue;
            ++outputs;
        }
        this.minOn = Math.min(this.minOn, outputs);
        if (this.maxOn < this.minOn && this.maxOn >= 0) {
            this.maxOn = this.minOn;
        }
        boolean first = true;
        while (on < this.maxOn || this.maxOn < 0) {
            for (int i = 0; i < chip.getOutputCount(); i = (int)((short)(i + 1))) {
                if (!chip.isValid(i)) continue;
                if (first) {
                    chip.setOutput(i, false);
                }
                boolean state = ThreadLocalRandom.current().nextBoolean();
                boolean changed = false;
                if (on >= this.maxOn && this.maxOn >= 0) {
                    state = false;
                }
                if (state && !chip.getOutput(i)) {
                    chip.setOutput(i, state);
                    changed = true;
                }
                if (state && changed) {
                    ++on;
                    continue;
                }
                if (state || !changed) continue;
                --on;
            }
            first = false;
            if (on < this.minOn) continue;
        }
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new RandomBit(this.getServer(), sign, this);
        }

        @Override
        public String[] getLongDescription() {
            return new String[]{"The '''MC1020''' generates a random state whenever the input (the \"clock\") goes from low to high."};
        }

        @Override
        public String[] getPinDescription(ChipState state) {
            String[] pins = new String[state.getInputCount() + state.getOutputCount()];
            pins[0] = "Trigger IC";
            for (int i = 1; i < pins.length; ++i) {
                pins[i] = "Random Output";
            }
            return pins;
        }

        @Override
        public String getShortDescription() {
            return "Randomly sets the output on high.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"Min Outputs:Max Outputs", null};
        }
    }
}

