/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.logic;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.plugin.Plugin;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.mechanics.ic.AbstractIC;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.mechanics.ic.ICVerificationException;
import org.enginehub.craftbook.mechanics.ic.RestrictedIC;
import org.enginehub.craftbook.util.RegexUtil;

public class Pulser
extends AbstractIC {
    private int pulseLength;
    private int startDelay;
    private int pulseCount;
    private int pauseLength;
    private int taskId;
    private boolean running;

    public Pulser(Server server, BukkitChangedSign block, ICFactory factory) {
        super(server, block, factory);
    }

    @Override
    public void load() {
        String[] split;
        String line2 = this.getLine(2);
        String line3 = this.getLine(3);
        if (line2 != null && !line2.isEmpty()) {
            split = RegexUtil.COLON_PATTERN.split(line2, 2);
            this.pulseLength = Integer.parseInt(split[0]);
            this.startDelay = split.length > 1 ? Integer.parseInt(split[1]) : 1;
        } else {
            this.pulseLength = 5;
            this.startDelay = 1;
        }
        if (line3 != null && !line3.isEmpty()) {
            split = RegexUtil.COLON_PATTERN.split(line3, 2);
            this.pulseCount = Math.max(1, Integer.parseInt(split[0]));
            this.pauseLength = split.length > 1 ? Math.max(1, Integer.parseInt(split[1])) : 5;
        } else {
            this.pulseCount = 1;
            this.pauseLength = 5;
        }
        this.getSign().setLine(2, (Component)Component.text((String)(this.pulseLength + ":" + this.startDelay)));
        this.getSign().setLine(3, (Component)Component.text((String)(this.pulseCount + ":" + this.pauseLength)));
        this.getSign().update(false);
    }

    @Override
    public String getTitle() {
        return "Pulser";
    }

    @Override
    public String getSignTitle() {
        return "PULSER";
    }

    @Override
    public final void trigger(ChipState chip) {
        if (this.getInput(chip)) {
            this.startThread(chip);
        }
    }

    private void startThread(ChipState chip) {
        if (this.running) {
            return;
        }
        this.taskId = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)CraftBookPlugin.inst(), (Runnable)new PulseTask(chip, this.pulseLength, this.pulseCount, this.pauseLength), (long)this.startDelay, 1L);
        this.running = true;
    }

    private void stopThread() {
        Bukkit.getScheduler().cancelTask(this.taskId);
        this.running = false;
    }

    protected boolean getInput(ChipState chip) {
        return chip != null && chip.getInput(0);
    }

    protected void setOutput(ChipState chip, boolean on) {
        if (chip == null) {
            return;
        }
        chip.setOutput(0, on);
    }

    protected class PulseTask
    implements Runnable {
        private final ChipState chip;
        private final int pulseLength;
        private final int pulseCount;
        private final int pauseLength;
        private int currentTick;
        private int currentPulseCount;
        private int currentPulse;
        private boolean on = false;

        public PulseTask(ChipState chip, int pulseLength, int pulseCount, int pauseLength) {
            if (pulseLength == 0) {
                pulseLength = 1;
            }
            if (pauseLength == 0) {
                pauseLength = 1;
            }
            this.chip = chip;
            this.pulseLength = pulseLength;
            this.pulseCount = pulseCount;
            this.pauseLength = pauseLength;
        }

        @Override
        public void run() {
            ++this.currentTick;
            if (this.currentTick < 2) {
                this.startPulse();
                return;
            }
            if (this.on) {
                if (this.currentPulse % this.pulseLength == 0) {
                    this.stopPulse();
                } else {
                    this.increasePulse();
                }
            } else if (this.currentTick % this.pauseLength == 0) {
                this.startPulse();
            }
            if (!this.on && this.currentPulseCount % this.pulseCount == 0) {
                Pulser.this.stopThread();
            }
        }

        private void startPulse() {
            Pulser.this.setOutput(this.chip, true);
            ++this.currentPulse;
            this.on = true;
        }

        private void stopPulse() {
            Pulser.this.setOutput(this.chip, false);
            this.currentPulse = 0;
            ++this.currentPulseCount;
            this.on = false;
        }

        private void increasePulse() {
            ++this.currentPulse;
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new Pulser(this.getServer(), sign, this);
        }

        @Override
        public void verify(BukkitChangedSign sign) throws ICVerificationException {
            String[] split;
            String line2 = PlainTextComponentSerializer.plainText().serialize(sign.getLine(2));
            String line3 = PlainTextComponentSerializer.plainText().serialize(sign.getLine(3));
            if (!line2.isEmpty()) {
                try {
                    split = RegexUtil.COLON_PATTERN.split(line2, 2);
                    Integer.parseInt(split[0]);
                    if (split.length > 1) {
                        Integer.parseInt(split[1]);
                    }
                }
                catch (Exception e) {
                    throw new ICVerificationException("You can only write numbers in line 3. See /icdocs for help");
                }
            }
            if (!line3.isEmpty()) {
                try {
                    split = RegexUtil.COLON_PATTERN.split(line3, 2);
                    Integer.parseInt(split[0]);
                    if (split.length > 1) {
                        Integer.parseInt(split[1]);
                    }
                }
                catch (Exception e) {
                    throw new ICVerificationException("You can only write numbers in line 4. See /icdocs for help");
                }
            }
        }

        @Override
        public String getShortDescription() {
            return "Fires a (choosable) pulse of high-signals with a choosable length of the signal and the pause between the pulses when the input goes from low to high.";
        }

        @Override
        public String[] getPinDescription(ChipState state) {
            return new String[]{"Trigger IC", "Pulse Output"};
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"[pulselength[:startdelay]]", "[pulsecount[:pauselength in serverticks]]"};
        }
    }
}

