/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.logic;

import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.mechanics.ic.AbstractIC;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.mechanics.ic.ICVerificationException;

public class NotDelayer
extends AbstractIC {
    private BukkitTask taskId;

    public NotDelayer(Server server, BukkitChangedSign block, ICFactory factory) {
        super(server, block, factory);
    }

    @Override
    public String getTitle() {
        return "Not Delayer";
    }

    @Override
    public String getSignTitle() {
        return "NOT_DELAYER";
    }

    @Override
    public void trigger(ChipState chip) {
        long delay = Long.parseLong(this.getLine(2));
        if (chip.getInput(0)) {
            this.taskId = Bukkit.getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), () -> {
                if (chip.getInput(0)) {
                    chip.setOutput(0, false);
                }
            }, delay * 20L);
        } else {
            if (this.taskId != null) {
                this.taskId.cancel();
            }
            chip.setOutput(0, true);
        }
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new NotDelayer(this.getServer(), sign, this);
        }

        @Override
        public String[] getPinDescription(ChipState state) {
            return new String[]{"Trigger IC", "Delayed Output"};
        }

        @Override
        public void verify(BukkitChangedSign sign) throws ICVerificationException {
            try {
                Integer.parseInt(PlainTextComponentSerializer.plainText().serialize(sign.getLine(2)));
            }
            catch (Exception ignored) {
                throw new ICVerificationException("The third line needs to be a number.");
            }
        }
    }
}

