/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.logic;

import org.bukkit.Server;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.mechanics.ic.gates.logic.SimpleAnyInputLogicGate;

public class NandGate
extends SimpleAnyInputLogicGate {
    public NandGate(Server server, BukkitChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public String getTitle() {
        return "Nand Gate";
    }

    @Override
    public String getSignTitle() {
        return "NAND";
    }

    @Override
    protected boolean getResult(int wires, int on) {
        return wires > 0 && on != wires;
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new NandGate(this.getServer(), sign, this);
        }

        @Override
        public String[] getPinDescription(ChipState state) {
            return new String[]{"Input", "Input", "Input", "High if one or more inputs are high, but not all are high"};
        }

        @Override
        public String getShortDescription() {
            return "NAND Gate. Outputs high if all inputs are low.";
        }
    }
}

