/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.logic;

import org.bukkit.Server;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractIC;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;

public class Multiplexer
extends AbstractIC {
    public Multiplexer(Server server, BukkitChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public String getTitle() {
        return "Multiplexer";
    }

    @Override
    public String getSignTitle() {
        return "MULTIPLEXER";
    }

    @Override
    public void trigger(ChipState chip) {
        boolean swapper = chip.getInput(2);
        chip.setOutput(0, swapper ? chip.getInput(0) : chip.getInput(1));
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public String[] getPinDescription(ChipState state) {
            return new String[]{"Value to Carry if Input 3 High", "Value to Carry if Input 3 Low", "Swaps between Input 1 and 2", "Carried Value"};
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new Multiplexer(this.getServer(), sign, this);
        }
    }
}

