/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.logic;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import org.bukkit.Server;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractIC;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.mechanics.ic.ICManager;
import org.enginehub.craftbook.mechanics.ic.RestrictedIC;

public class MemorySetter
extends AbstractIC {
    File f;

    public MemorySetter(Server server, BukkitChangedSign block, ICFactory factory) {
        super(server, block, factory);
    }

    @Override
    public String getTitle() {
        return "Memory Setter";
    }

    @Override
    public String getSignTitle() {
        return "MEMORY SET";
    }

    @Override
    public void trigger(ChipState chip) {
        this.setMemory(chip);
    }

    @Override
    public void load() {
        this.f = new File(ICManager.inst().getRomFolder(), this.getLine(2) + ".dat");
        if (!this.f.exists()) {
            try {
                this.f.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean setMemory(ChipState chip) {
        try {
            PrintWriter pw = new PrintWriter(this.f, "UTF-8");
            for (int i = 0; i < chip.getInputCount(); ++i) {
                pw.print(chip.getInput(i) ? "1" : "0");
            }
            pw.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public String[] getLongDescription() {
            return new String[]{"The '''MC3300''' sets memory that can be read by the ([[../MC3301/]]) set to access the same file.", "", "This IC writes to a file in the filesystem stored in /plugins/CraftBook/rom/fileName.dat.", "This file can be accessed by other services to allow for external programs to interact with redstone."};
        }

        @Override
        public String[] getPinDescription(ChipState state) {
            return new String[]{"Bit to set 1", "Bit to set 2", "Bit to set 3", "Nothing"};
        }

        @Override
        public String getShortDescription() {
            return "Sets the memory state for a file for usage in the MemorySetter/Access IC group.";
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new MemorySetter(this.getServer(), sign, this);
        }
    }
}

