/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.logic;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.bukkit.Server;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractIC;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.mechanics.ic.ICManager;
import org.enginehub.craftbook.mechanics.ic.RestrictedIC;

public class MemoryAccess
extends AbstractIC {
    File f;

    public MemoryAccess(Server server, BukkitChangedSign block, ICFactory factory) {
        super(server, block, factory);
    }

    @Override
    public String getTitle() {
        return "ROM Accessor";
    }

    @Override
    public String getSignTitle() {
        return "ROM";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            this.readMemory(chip);
        }
    }

    @Override
    public void load() {
        this.f = new File(ICManager.inst().getRomFolder(), this.getLine(2) + ".dat");
        if (!this.f.exists()) {
            try {
                this.f.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean readMemory(ChipState chip) {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.f), "UTF-8"));
            String line = br.readLine();
            for (int i = 0; i < chip.getOutputCount(); ++i) {
                if (line == null || line.length() < i + 1) {
                    chip.setOutput(i, false);
                    continue;
                }
                chip.setOutput(i, line.charAt(i) == '1');
            }
            br.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public String[] getLongDescription() {
            return new String[]{"The '''MC3301''' gets memory that can be set by the ([[../MC3301/]]) set to access the same file.", "", "This IC reads from a file in the filesystem stored in /plugins/CraftBook/rom/fileName.dat.", "This file can be accessed by other services to allow for external programs to interact with redstone."};
        }

        @Override
        public String[] getPinDescription(ChipState state) {
            return new String[]{"Trigger IC", "Bit 1 State", "Bit 2 State", "Bit 3 State"};
        }

        @Override
        public String getShortDescription() {
            return "Gets the memory state from a file for usage in the MemorySetter/Access IC group.";
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new MemoryAccess(this.getServer(), sign, this);
        }
    }
}

