/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.logic;

import net.kyori.adventure.text.Component;
import org.bukkit.Server;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractIC;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.util.RegexUtil;

public class Marquee
extends AbstractIC {
    public Marquee(Server server, BukkitChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public String getTitle() {
        return "Marquee";
    }

    @Override
    public String getSignTitle() {
        return "MARQUEE";
    }

    @Override
    public void trigger(ChipState chip) {
        if (!chip.getInput(0)) {
            return;
        }
        boolean reverse = false;
        int next = 0;
        try {
            String[] st = RegexUtil.RIGHT_BRACKET_PATTERN.split(this.getLine(1), 2);
            if (st.length > 1) {
                reverse = st[1].equalsIgnoreCase("r");
            }
            next = Integer.parseInt(this.getLine(2));
        }
        catch (Exception st) {
            // empty catch block
        }
        if (next == 0) {
            next = reverse ? 3 : 1;
        }
        for (int i = 0; i < chip.getOutputCount(); i = (int)((short)(i + 1))) {
            chip.setOutput(i, false);
        }
        switch (next) {
            case 1: {
                chip.setOutput(1, true);
                break;
            }
            case 2: {
                chip.setOutput(0, true);
                break;
            }
            case 3: {
                chip.setOutput(2, true);
            }
        }
        next = reverse ? --next : ++next;
        if (next == 0) {
            next = 3;
        } else if (next == 4) {
            next = 1;
        }
        this.getSign().setLine(2, (Component)Component.text((int)next));
        this.getSign().update(false);
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new Marquee(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Sequentially sets all pins.";
        }

        @Override
        public String[] getPinDescription(ChipState state) {
            return new String[]{"Trigger IC", "Output 1", "Output 2", "Output 3"};
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"next pin to set", null};
        }
    }
}

