/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.logic;

import org.bukkit.Server;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.mechanics.ic.RestrictedIC;
import org.enginehub.craftbook.mechanics.ic.gates.logic.NotPulser;
import org.enginehub.craftbook.mechanics.ic.gates.logic.Pulser;

public class LowNotPulser
extends NotPulser {
    public LowNotPulser(Server server, BukkitChangedSign block, ICFactory factory) {
        super(server, block, factory);
    }

    @Override
    public String getTitle() {
        return "Low Not Pulser";
    }

    @Override
    public String getSignTitle() {
        return "LOW NOT PULSER";
    }

    @Override
    protected boolean getInput(ChipState chip) {
        return !chip.getInput(0);
    }

    @Override
    protected void setOutput(ChipState chip, boolean on) {
        chip.setOutput(0, !on);
    }

    public static class Factory
    extends Pulser.Factory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new LowNotPulser(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Fires a (choosable) pulse of low-signals with a choosable length of the signal and the pause between the pulses when the input goes from high to low.";
        }
    }
}

