/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.logic;

import org.bukkit.Server;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractIC;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;

public class JkFlipFlop
extends AbstractIC {
    public JkFlipFlop(Server server, BukkitChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public String getTitle() {
        return "JK negative edge-triggered flip flop";
    }

    @Override
    public String getSignTitle() {
        return "JK EDGE FLIP FLOP";
    }

    @Override
    public void trigger(ChipState chip) {
        boolean j = chip.getInput(1);
        boolean k = chip.getInput(2);
        if (chip.isTriggered(0) && !chip.getInput(0)) {
            if (j && k) {
                chip.setOutput(0, !chip.getOutput(0));
            } else if (j && !k) {
                chip.setOutput(0, true);
            } else if (k) {
                chip.setOutput(0, false);
            }
        }
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public String[] getPinDescription(ChipState state) {
            return new String[]{"Trigger IC", "Set", "Reset", "Output = Same if J and K = 0, 1 if J = 1, 0 if K = 1, and continuously toggling states if J and K = 1"};
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new JkFlipFlop(this.getServer(), sign, this);
        }
    }
}

