/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.logic;

import org.bukkit.Server;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractIC;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;

public class Inverter
extends AbstractIC {
    public Inverter(Server server, BukkitChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public String getTitle() {
        return "Inverter";
    }

    @Override
    public String getSignTitle() {
        return "INVERTER";
    }

    @Override
    public void trigger(ChipState chip) {
        chip.setOutput(0, !chip.getInput(0));
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new Inverter(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Invert a redstone signal.";
        }

        @Override
        public String[] getPinDescription(ChipState state) {
            return new String[]{"Trigger IC", "Opposite of Input"};
        }

        @Override
        public String[] getLongDescription() {
            return new String[]{"The '''MC1001''' inverts the input state.", "", "Equivalent [[../Perlstone/]] script: <code>A!r</code>", "", "== Uses ==", "* Inverting a signal state."};
        }
    }
}

